/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.security.listener;

import io.meeds.portal.security.constant.UserRegistrationType;
import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

public class PortalRegistrationUpdateListener
extends Listener<Object, UserRegistrationType> {
    private NavigationService navigationService;
    private List<String> managedPages;

    public PortalRegistrationUpdateListener(NavigationService navigationService, InitParams params) {
        this.navigationService = navigationService;
        this.managedPages = params.getValuesParam("managed-pages").getValues();
    }

    public void onEvent(Event<Object, UserRegistrationType> event) throws Exception {
        boolean isOpen = event.getData() == UserRegistrationType.OPEN;
        this.managedPages.forEach(navUri -> {
            NodeContext navNode = this.navigationService.loadNode(SiteKey.portal((String)"public"), navUri);
            if (navNode != null) {
                NodeState state = navNode.getState().builder().visibility(isOpen ? Visibility.DISPLAYED : Visibility.HIDDEN).build();
                navNode.setState(state);
                this.navigationService.updateNode(Long.valueOf(Long.parseLong(navNode.getId())), state);
            }
        });
    }
}

