/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.rest.CollectionEntity;
import org.exoplatform.portal.rest.model.GroupRestEntity;
import org.exoplatform.portal.rest.model.MembershipRestEntity;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.MembershipImpl;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.search.GroupSearchService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

@Path(value="v1/groups")
@Tag(name="v1/groups", description="Manages groups operations")
public class GroupRestResourcesV1
implements ResourceContainer {
    public static final int DEFAULT_LIMIT = 20;
    public static final int DEFAULT_OFFSET = 0;
    private GroupSearchService groupSearchService;
    private OrganizationService organizationService;
    private UserACL userACL;

    public GroupRestResourcesV1(OrganizationService organizationService, GroupSearchService groupSearchService, UserACL userACL) {
        this.organizationService = organizationService;
        this.groupSearchService = groupSearchService;
        this.userACL = userACL;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Gets groups", description="Gets groups", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getGroups(@Context UriInfo uriInfo, @Parameter(description="Search text to filter groups") @QueryParam(value="q") String q, @Parameter(description="Offset") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @QueryParam(value="limit") int limit, @Parameter(description="Whether build tree until results or not") @Schema(defaultValue="false") @QueryParam(value="tree") boolean buildTree, @QueryParam(value="returnSize") boolean returnSize, @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : 0;
        limit = limit > 0 ? limit : 20;
        int size = this.groupSearchService.searchGroups(q).getSize();
        limit = limit < size ? limit : size;
        Group[] groups = (Group[])this.groupSearchService.searchGroups(q).load(offset, limit);
        List listAllGroups = Arrays.stream(groups).map(group -> new GroupRestEntity((Group)group)).collect(Collectors.toList());
        CollectionEntity<Object> result = null;
        if (buildTree) {
            ArrayList<GroupRestEntity> rootGroups = new ArrayList<GroupRestEntity>();
            HashMap<String, GroupRestEntity> groupsById = new HashMap<String, GroupRestEntity>();
            for (GroupRestEntity groupRestEntity : listAllGroups) {
                this.buildTree(rootGroups, groupsById, groupRestEntity);
            }
            result = new CollectionEntity(rootGroups, offset, limit, rootGroups.size());
        } else {
            result = new CollectionEntity(listAllGroups, offset, limit, size);
        }
        return Response.ok(result).build();
    }

    @GET
    @Path(value="tree")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Gets groups tree", description="Gets groups tree", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getGroupsTree(@Context UriInfo uriInfo, @Parameter(description="Parent groupId to search") @QueryParam(value="parentId") String parentId, @Parameter(description="Search text to filter groups") @QueryParam(value="q") String q, @Parameter(description="Offset") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @QueryParam(value="limit") int limit, @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        int limitToFetch;
        offset = offset > 0 ? offset : 0;
        limit = limit > 0 ? limit : 20;
        Group parentGroup = null;
        if (StringUtils.isNotBlank((CharSequence)parentId) && (parentGroup = this.organizationService.getGroupHandler().findGroupById(parentId)) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ListAccess childrenGroupsListAccess = this.organizationService.getGroupHandler().findGroupChildren(parentGroup, q);
        int totalSize = childrenGroupsListAccess.getSize();
        if (totalSize < offset + (limitToFetch = limit)) {
            limitToFetch = totalSize - offset;
        }
        Group[] groups = null;
        if (limitToFetch <= 0) {
            groups = new Group[]{};
        } else {
            groups = (Group[])childrenGroupsListAccess.load(offset, limitToFetch);
            if (!returnSize) {
                totalSize = 0;
            }
        }
        List<Group> groupsList = Arrays.asList(groups);
        CollectionEntity<Group> result = new CollectionEntity<Group>(groupsList, offset, limit, totalSize);
        return Response.ok(result).build();
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Operation(summary="Creates a new group", description="Creates a new group", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createGroup(GroupImpl group) throws Exception {
        String regex = "^[a-zA-Z0-9-_]+$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(group.getGroupName());
        boolean isValid = matcher.matches();
        if (group == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Group object is required").build();
        }
        if (StringUtils.isBlank((CharSequence)group.getGroupName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:MANDATORY").build();
        }
        if (!isValid) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:INVALID").build();
        }
        if (StringUtils.isBlank((CharSequence)group.getLabel())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"LABEL:MANDATORY").build();
        }
        String groupId = (String)(group.getParentId() == null ? "" : group.getParentId() + "/") + group.getGroupName();
        if (this.organizationService.getGroupHandler().findGroupById(groupId) != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"NAME:ALREADY_EXISTS").build();
        }
        Group parent = null;
        if (group.getParentId() != null && (parent = this.organizationService.getGroupHandler().findGroupById(group.getParentId())) == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"PARENT:NOT_FOUND").build();
        }
        this.organizationService.getGroupHandler().addChild(parent, (Group)group, true);
        return Response.noContent().build();
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Operation(summary="Updates an existing Group", description="Updates an existing Group", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateGroup(GroupImpl group) throws Exception {
        if (group == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Group object is required").build();
        }
        if (StringUtils.isBlank((CharSequence)group.getId()) || this.organizationService.getGroupHandler().findGroupById(group.getId()) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"ID:NOT_FOUND").build();
        }
        this.organizationService.getGroupHandler().saveGroup((Group)group, true);
        return Response.noContent().build();
    }

    @DELETE
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Deletes an existing Group", description="Deletes an existing Group", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteGroup(@Parameter(description="Group id", required=true) @QueryParam(value="groupId") String groupId) throws Exception {
        if (StringUtils.isBlank((CharSequence)groupId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"ID:MANDATORY").build();
        }
        if (this.userACL.getMandatoryGroups() != null && this.userACL.getMandatoryGroups().contains(groupId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MandatoryGroup").build();
        }
        Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
        if (group == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"ID:NOT_FOUND").build();
        }
        this.organizationService.getGroupHandler().removeGroup(group, true);
        return Response.noContent().build();
    }

    @GET
    @Path(value="memberships")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Gets Group memberships list", description="Gets Group memberships list", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Group not found"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding")})
    public Response getGroupMemberships(@Parameter(description="Group identifier", required=true) @QueryParam(value="groupId") String groupId, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of users found or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        int limitToFetch;
        offset = offset > 0 ? offset : 0;
        limit = limit > 0 ? limit : 20;
        Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
        if (group == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ListAccess membershipsByGroup = this.organizationService.getMembershipHandler().findAllMembershipsByGroup(group);
        int totalSize = membershipsByGroup.getSize();
        if (totalSize < offset + (limitToFetch = limit)) {
            limitToFetch = totalSize - offset;
        }
        ArrayList<MembershipRestEntity> membershipEntities = new ArrayList<MembershipRestEntity>();
        if (limitToFetch > 0) {
            Membership[] memberships;
            for (Membership membership : memberships = (Membership[])membershipsByGroup.load(offset, limitToFetch)) {
                User user = this.organizationService.getUserHandler().findUserByName(membership.getUserName(), UserStatus.ANY);
                membershipEntities.add(new MembershipRestEntity(membership, group, user));
            }
            if (!returnSize) {
                totalSize = 0;
            }
        }
        return Response.ok(new CollectionEntity(membershipEntities, offset, limit, totalSize)).build();
    }

    @POST
    @Path(value="memberships")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Operation(summary="Creates a new membership", description="Creates a new membership", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createMembership(@RequestBody(description="Membership Object") MembershipImpl membership) throws Exception {
        if (membership == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Membership object is required").build();
        }
        if (StringUtils.isBlank((CharSequence)membership.getGroupId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"GROUP_ID:MANDATORY").build();
        }
        if (StringUtils.isBlank((CharSequence)membership.getUserName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"USER:MANDATORY").build();
        }
        if (StringUtils.isBlank((CharSequence)membership.getMembershipType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MEMBERSHIP_TYPE:MANDATORY").build();
        }
        if (this.organizationService.getMembershipHandler().findMembership(membership.getId()) != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MEMBERSHIP:ALREADY_EXISTS").build();
        }
        User user = this.organizationService.getUserHandler().findUserByName(membership.getUserName(), UserStatus.ANY);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"USER:NOT_FOUND").build();
        }
        Group group = this.organizationService.getGroupHandler().findGroupById(membership.getGroupId());
        if (group == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"GROUP:NOT_FOUND").build();
        }
        MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(membership.getMembershipType());
        if (membershipType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MEMBERSHIP_TYPE:NOT_FOUND").build();
        }
        this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
        return Response.noContent().build();
    }

    @POST
    @Path(value="memberships/bulk")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Operation(summary="Creates new memberships", description="Creates new memberships", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createMultipleMembership(@RequestBody(description="List of membership objects") List<MembershipImpl> memberships) throws Exception {
        for (MembershipImpl membership : memberships) {
            if (membership == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Membership object is required").build();
            }
            if (StringUtils.isBlank((CharSequence)membership.getGroupId())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"GROUP_ID:MANDATORY").build();
            }
            if (StringUtils.isBlank((CharSequence)membership.getUserName())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"USER:MANDATORY").build();
            }
            if (StringUtils.isBlank((CharSequence)membership.getMembershipType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MEMBERSHIP_TYPE:MANDATORY").build();
            }
            if (this.organizationService.getMembershipHandler().findMembership(membership.getId()) != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MEMBERSHIP:ALREADY_EXISTS").build();
            }
            User user = this.organizationService.getUserHandler().findUserByName(membership.getUserName(), UserStatus.ANY);
            if (user == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"USER:NOT_FOUND").build();
            }
            Group group = this.organizationService.getGroupHandler().findGroupById(membership.getGroupId());
            if (group == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"GROUP:NOT_FOUND").build();
            }
            MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(membership.getMembershipType());
            if (membershipType == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MEMBERSHIP_TYPE:NOT_FOUND").build();
            }
            this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="memberships")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Operation(summary="Updates an existing membership", description="Updates an existing membership", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateMembership(@Parameter(description="Membership identifier with format: MEMBERSHIP_TYPE:GROUP_ID:USER_NAME", required=true) @QueryParam(value="membershipId") String membershipId, @RequestBody(description="Membership object") MembershipImpl membership) throws Exception {
        if (membership == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Membership object is required").build();
        }
        if (StringUtils.isBlank((CharSequence)membershipId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Membership identifier object is required").build();
        }
        if (StringUtils.isBlank((CharSequence)membership.getGroupId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"GROUP_ID:MANDATORY").build();
        }
        if (StringUtils.isBlank((CharSequence)membership.getUserName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"USER:MANDATORY").build();
        }
        if (StringUtils.isBlank((CharSequence)membership.getMembershipType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MEMBERSHIP_TYPE:MANDATORY").build();
        }
        Membership oldMembership = this.organizationService.getMembershipHandler().findMembership(membershipId);
        if (oldMembership == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"MEMBERSHIP:NOT_FOUND").build();
        }
        if (membershipId.equals(membership.getId())) {
            return Response.noContent().build();
        }
        if (this.organizationService.getMembershipHandler().findMembership(membership.getId()) != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MEMBERSHIP:ALREADY_EXISTS").build();
        }
        User user = this.organizationService.getUserHandler().findUserByName(membership.getUserName(), UserStatus.ANY);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"USER:NOT_FOUND").build();
        }
        Group group = this.organizationService.getGroupHandler().findGroupById(membership.getGroupId());
        if (group == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"GROUP:NOT_FOUND").build();
        }
        MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(membership.getMembershipType());
        if (membershipType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MEMBERSHIP_TYPE:NOT_FOUND").build();
        }
        this.organizationService.getMembershipHandler().removeMembership(membershipId, true);
        this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="memberships")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Deletes an existing membership", description="Deletes an existing membership", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteMembership(@Parameter(description="Membership identifier with format: MEMBERSHIP_TYPE:USER_NAME:GROUP_ID", required=true) @QueryParam(value="membershipId") String membershipId) throws Exception {
        if (StringUtils.isBlank((CharSequence)membershipId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MEMBERSHIP:MANDATORY").build();
        }
        if (this.organizationService.getMembershipHandler().findMembership(membershipId) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"NAME:NOT_FOUND").build();
        }
        this.organizationService.getMembershipHandler().removeMembership(membershipId, true);
        return Response.noContent().build();
    }

    @GET
    @Path(value="treeMembers")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Schema
    @Operation(summary="Gets groups tree", description="Gets groups tree", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled", content={@Content(schema=@Schema(implementation=CollectionEntity.class))}), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getGroupsTreeMembers(@Context UriInfo uriInfo, @Parameter(description="Search text to filter groups") @QueryParam(value="q") String q, @Parameter(description="Group member") @QueryParam(value="groupMember") String groupMember, @Parameter(description="Group type") @QueryParam(value="groupType") String groupType, @Parameter(description="Offset") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @QueryParam(value="limit") int limit, @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="allGroupsForAdmin") @QueryParam(value="allGroupsForAdmin") boolean allGroupsForAdmin, @Parameter(description="List of excluded parent/type groups") @QueryParam(value="excludeParentGroup") List<String> excludeParentGroup) throws Exception {
        int limitToFetch;
        Identity identity;
        try {
            identity = ConversationState.getCurrent().getIdentity();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (!this.userACL.isAdministrator(identity) && !identity.isMemberOf(groupMember)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (StringUtils.isNotBlank((CharSequence)q)) {
            q = q.replace("#", " ").replace("$", " ").replace("_", " ").replace(".", " ");
        }
        offset = offset > 0 ? offset : 0;
        limit = limit > 0 ? limit : 20;
        Group[] groups = null;
        int totalSize = 0;
        Collection userGroupsList = null;
        userGroupsList = allGroupsForAdmin && this.userACL.isAdministrator(identity) ? this.organizationService.getGroupHandler().findAllGroupsByKeyword(q, excludeParentGroup) : this.organizationService.getGroupHandler().findGroupsOfUserByKeyword(identity.getUserId(), q, excludeParentGroup);
        totalSize = userGroupsList.size();
        if (totalSize < offset + (limitToFetch = limit)) {
            limitToFetch = totalSize - offset;
        }
        if (limitToFetch <= 0) {
            groups = new Group[]{};
        } else {
            groups = userGroupsList.toArray(new Group[0]);
            if (!returnSize) {
                totalSize = 0;
            }
        }
        List<Group> groupsList = Arrays.asList(groups);
        CollectionEntity<Group> result = new CollectionEntity<Group>(groupsList, offset, limit, totalSize);
        return Response.ok(result).build();
    }

    private void buildTree(List<GroupRestEntity> rootGroups, Map<String, GroupRestEntity> groupsById, GroupRestEntity groupRestEntity) throws Exception {
        groupsById.put(groupRestEntity.getId(), groupRestEntity);
        String parentId = groupRestEntity.getParentId();
        if (parentId == null) {
            if (!rootGroups.contains(groupRestEntity)) {
                rootGroups.add(groupRestEntity);
            }
            return;
        }
        GroupRestEntity parentGroupEntity = groupsById.get(parentId);
        if (parentGroupEntity == null) {
            Group parentGroup = this.organizationService.getGroupHandler().findGroupById(parentId);
            parentGroupEntity = new GroupRestEntity(parentGroup);
            groupsById.put(parentId, parentGroupEntity);
        }
        parentGroupEntity.addChild(groupRestEntity);
        this.buildTree(rootGroups, groupsById, parentGroupEntity);
    }
}

