/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.dao;

import io.meeds.wallet.reward.entity.WalletRewardEntity;
import jakarta.transaction.Transactional;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Component;

@Component
public interface RewardDAO
extends JpaRepository<WalletRewardEntity, Long> {
    @Query(value="    SELECT rw FROM Reward rw WHERE rw.period.id = :periodId\n")
    public List<WalletRewardEntity> findRewardsByPeriodId(@Param(value="periodId") long var1);

    @Query(value="    SELECT rw\n    FROM Reward rw\n    LEFT JOIN WalletTransaction te ON rw.transactionHash = te.hash\n    WHERE rw.period.id = :periodId\n      AND (\n          :status = 'ALL'\n          OR (:status = 'INELIGIBLE' AND rw.tokensSent <= 0 AND rw.tokensToSend <= 0)\n          OR (:status = 'VALID' AND rw.tokensSent > 0 AND te.isSuccess = true)\n          OR (:status = 'ESTIMATED' AND rw.tokensToSend > 0 AND rw.tokensSent <= 0)\n          OR (:status = 'FAILED' AND rw.transactionHash IS NOT NULL AND te.isPending = false AND te.isSuccess = false)\n      )\n")
    public Page<WalletRewardEntity> findWalletRewardsByPeriodId(@Param(value="periodId") long var1, @Param(value="status") String var3, Pageable var4);

    @Query(value="    SELECT rw\n    FROM Reward rw\n    LEFT JOIN WalletTransaction te ON rw.transactionHash = te.hash\n    WHERE rw.period.id = :periodId\n      AND (rw.identityId IN :identityIds)\n      AND (\n          :status = 'ALL'\n          OR (:status = 'INELIGIBLE' AND rw.tokensSent <= 0 AND rw.tokensToSend <= 0)\n          OR (:status = 'VALID' AND rw.tokensSent > 0 AND te.isSuccess = true)\n          OR (:status = 'ESTIMATED' AND rw.tokensToSend > 0 AND rw.tokensSent <= 0)\n          OR (:status = 'FAILED' AND rw.transactionHash IS NOT NULL AND te.isPending = false AND te.isSuccess = false)\n      )\n")
    public Page<WalletRewardEntity> findWalletRewardsByPeriodIdAndIdentityIds(@Param(value="periodId") long var1, @Param(value="identityIds") List<Long> var3, @Param(value="status") String var4, Pageable var5);

    @Query(value="    SELECT SUM(rw.points) FROM Reward rw WHERE rw.period.id = :periodId AND\n    (:isValid = TRUE AND (rw.tokensSent > 0 OR rw.tokensToSend > 0) OR :isValid = FALSE AND (rw.tokensSent <= 0 AND rw.tokensToSend <= 0))\n")
    public Double countWalletRewardsPointsByPeriodIdAndStatus(@Param(value="periodId") long var1, @Param(value="isValid") boolean var3);

    @Query(value="    SELECT rw FROM Reward rw JOIN rw.period WHERE rw.identityId = :identityId ORDER BY rw.period.startTime DESC, rw.period.endTime ASC\n")
    public List<WalletRewardEntity> findWalletRewardEntitiesByIdentityId(@Param(value="identityId") long var1, Pageable var3);

    public double countWalletRewardEntitiesByIdentityId(long var1);

    @Query(value="    SELECT rw FROM Reward rw WHERE rw.identityId = :identityId AND rw.period.id = :periodId\n")
    public List<WalletRewardEntity> findRewardByIdentityIdAndPeriodId(@Param(value="identityId") long var1, @Param(value="periodId") long var3);

    @Modifying
    @Transactional
    @Query(value="UPDATE Reward rw SET rw.transactionHash = :newHash WHERE rw.transactionHash = :oldHash\n")
    public void replaceRewardTransactions(@Param(value="oldHash") String var1, @Param(value="newHash") String var2);

    @Query(value="  SELECT COUNT(*) + 1 AS reward_rank\n  FROM Reward rw\n  WHERE rw.period.id = :periodId\n    AND rw.points > (\n        SELECT rw2.points\n        FROM Reward rw2\n        WHERE rw2.id = :id\n    )\n")
    public Integer findRankById(@Param(value="id") long var1, @Param(value="periodId") long var3);

    @Modifying
    @Query(value="DELETE FROM Reward wr WHERE wr.period.id = :periodId\n")
    public void deleteRewardsByPeriodId(@Param(value="periodId") long var1);
}

