/*
 * Decompiled with CFR 0.152.
 */
package org.suigeneris.jrcs.rcs.impl;

import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.suigeneris.jrcs.diff.Diff;
import org.suigeneris.jrcs.rcs.impl.Line;
import org.suigeneris.jrcs.rcs.impl.Node;

public class Lines
extends ArrayList {
    public static final Format annotationFormat = new MessageFormat("{0,,        } ({1} {2,  date,dd-MMM-yyyy}):");

    public Lines() {
    }

    public Lines(String text) {
        this(null, Diff.stringToArray((String)text));
    }

    public Lines(Node release, String text) {
        this(release, Diff.stringToArray((String)text));
    }

    public Lines(Object[] text) {
        this(null, text);
    }

    public Lines(Node release, Object[] text) {
        for (int i = 0; i < text.length; ++i) {
            super.add(new Line(release, text[i]));
        }
    }

    public boolean add(Object o) {
        return super.add((Line)o);
    }

    public Object[] toArray() {
        return this.toArray(false);
    }

    public Object[] toArray(boolean annotate) {
        Object[] result = new Object[this.size()];
        Iterator r = this.iterator();
        int i = 0;
        while (r.hasNext()) {
            Line l = (Line)r.next();
            Object o = l.getText();
            if (annotate) {
                Node rev = l.getRevision();
                o = annotationFormat.format(new Object[]{rev.getVersion(), rev.getAuthor(), rev.getDate()});
            }
            result[i++] = o;
        }
        return result;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean annotate) {
        return Diff.arrayToString((Object[])this.toArray(annotate));
    }
}

