/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Transaction {
    public static final BigInteger DEFAULT_GAS = BigInteger.valueOf(9000L);
    private String from;
    private String to;
    private BigInteger gas;
    private BigInteger gasPrice;
    private BigInteger value;
    private String data;
    private BigInteger nonce;
    private Long chainId;
    private BigInteger maxPriorityFeePerGas;
    private BigInteger maxFeePerGas;

    public Transaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        this(from, nonce, gasPrice, gasLimit, to, value, data, null, null, null);
    }

    public Transaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data, Long chainId, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas) {
        this.chainId = chainId;
        this.from = from;
        this.to = to;
        this.gas = gasLimit;
        this.gasPrice = gasPrice;
        this.value = value;
        if (data != null) {
            this.data = Numeric.prependHexPrefix((String)data);
        }
        this.nonce = nonce;
        this.maxPriorityFeePerGas = maxPriorityFeePerGas;
        this.maxFeePerGas = maxFeePerGas;
    }

    public static Transaction createContractTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String init) {
        return new Transaction(from, nonce, gasPrice, gasLimit, null, value, init);
    }

    public static Transaction createContractTransaction(String from, BigInteger nonce, BigInteger gasPrice, String init) {
        return Transaction.createContractTransaction(from, nonce, gasPrice, null, null, init);
    }

    public static Transaction createEtherTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value) {
        return new Transaction(from, nonce, gasPrice, gasLimit, to, value, null);
    }

    public static Transaction createFunctionCallTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        return new Transaction(from, nonce, gasPrice, gasLimit, to, value, data);
    }

    public static Transaction createFunctionCallTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data) {
        return new Transaction(from, nonce, gasPrice, gasLimit, to, null, data);
    }

    public static Transaction createEthCallTransaction(String from, String to, String data, BigInteger weiValue) {
        return new Transaction(from, null, null, null, to, weiValue, data);
    }

    public static Transaction createEthCallTransaction(String from, String to, String data) {
        return new Transaction(from, null, null, null, to, null, data);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGas() {
        return Transaction.convert(this.gas);
    }

    public String getGasPrice() {
        return Transaction.convert(this.gasPrice);
    }

    public String getValue() {
        return Transaction.convert(this.value);
    }

    public String getData() {
        return this.data;
    }

    public String getNonce() {
        return Transaction.convert(this.nonce);
    }

    public String getChainId() {
        if (this.chainId != null) {
            return Transaction.convert(BigInteger.valueOf(this.chainId));
        }
        return null;
    }

    public String getMaxPriorityFeePerGas() {
        return Transaction.convert(this.maxPriorityFeePerGas);
    }

    public String getMaxFeePerGas() {
        return Transaction.convert(this.maxFeePerGas);
    }

    private static String convert(BigInteger value) {
        if (value != null) {
            return Numeric.encodeQuantity((BigInteger)value);
        }
        return null;
    }
}

