/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonData;
import org.springframework.lang.Nullable;

final class CollectionJsonItem<T> {
    @Nullable
    private final String href;
    private final List<CollectionJsonData> data;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Links links;
    @Nullable
    private final T rawData;
    private static final Set<Class<?>> PRIMITIVE_TYPES = Collections.singleton(String.class);

    @JsonCreator
    CollectionJsonItem(@JsonProperty(value="href") @Nullable String href, @JsonProperty(value="data") @Nullable List<CollectionJsonData> data, @JsonProperty(value="links") @Nullable Links links) {
        this.href = href;
        this.data = data == null ? Collections.emptyList() : data;
        this.links = links == null ? Links.NONE : links;
        this.rawData = null;
    }

    CollectionJsonItem() {
        this(null, null, null);
    }

    CollectionJsonItem(String href, List<CollectionJsonData> data, Links links, T rawData) {
        this.href = href;
        this.data = data;
        this.links = links;
        this.rawData = rawData;
    }

    CollectionJsonItem<T> withLinks(Link ... links) {
        return new CollectionJsonItem<T>(this.href, this.data, Links.of(links), this.rawData);
    }

    CollectionJsonItem<T> withLinks(Links links) {
        return this.links == links ? this : new CollectionJsonItem<T>(this.href, this.data, links, this.rawData);
    }

    CollectionJsonItem<T> withOwnSelfLink() {
        String href = this.href;
        if (href == null) {
            return this;
        }
        return this.withLinks(Links.of(Link.of(href)).merge(Links.MergeMode.SKIP_BY_REL, this.links));
    }

    CollectionJsonItem<T> withHref(@Nullable String href) {
        return this.href == href ? this : new CollectionJsonItem<T>(href, this.data, this.links, this.rawData);
    }

    CollectionJsonItem<T> withData(List<CollectionJsonData> data) {
        return this.data == data ? this : new CollectionJsonItem<T>(this.href, data, this.links, this.rawData);
    }

    CollectionJsonItem<T> withRawData(@Nullable T rawData) {
        return this.rawData == rawData ? this : new CollectionJsonItem<T>(this.href, this.data, this.links, rawData);
    }

    @JsonProperty
    @Nullable
    String getHref() {
        return this.href;
    }

    @JsonProperty
    List<CollectionJsonData> getData() {
        if (!this.data.isEmpty()) {
            return this.data;
        }
        if (this.rawData != null && PRIMITIVE_TYPES.contains(this.rawData.getClass())) {
            return Collections.singletonList(new CollectionJsonData().withValue(this.rawData));
        }
        if (this.rawData == null) {
            return Collections.emptyList();
        }
        return PropertyUtils.extractPropertyValues(this.rawData).entrySet().stream().map(entry -> new CollectionJsonData().withName((String)entry.getKey()).withValue(entry.getValue())).collect(Collectors.toList());
    }

    @JsonProperty
    Links getLinks() {
        return this.links;
    }

    @Nullable
    @JsonIgnore
    T getRawData() {
        return this.rawData;
    }

    @Nullable
    Object toRawData(JavaType javaType) {
        if (this.data.isEmpty()) {
            return null;
        }
        if (PRIMITIVE_TYPES.contains(javaType.getRawClass())) {
            return this.data.get(0).getValue();
        }
        return PropertyUtils.createObjectFromProperties(javaType.getRawClass(), this.data.stream().collect(Collectors.toMap(CollectionJsonData::getName, CollectionJsonData::getValue)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionJsonItem that = (CollectionJsonItem)o;
        return Objects.equals(this.href, that.href) && Objects.equals(this.data, that.data) && Objects.equals(this.links, that.links) && Objects.equals(this.rawData, that.rawData);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.data, this.links, this.rawData);
    }

    public String toString() {
        return "CollectionJsonItem(href=" + this.href + ", data=" + String.valueOf(this.data) + ", links=" + String.valueOf(this.links) + ", rawData=" + String.valueOf(this.rawData) + ")";
    }
}

