/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.relationship;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.RelationshipEntity;

@Path(value="v1/social/relationships")
@Tag(name="v1/social/relationships", description="Managing relationships of identities")
public class RelationshipsRestResources
implements ResourceContainer {
    private RelationshipManager relationshipManager;
    private IdentityManager identityManager;

    public RelationshipsRestResources(RelationshipManager relationshipManager, IdentityManager identityManager) {
        this.relationshipManager = relationshipManager;
        this.identityManager = identityManager;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets relationships of identities", method="GET", description="This returns a list of relationships in the following cases: <br/><ul><li>the authenticated user has permissions to view the 2 objects linked to the 2 identities</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="412", description="Precondition failed, check your input params")})
    public Response getRelationships(@Context UriInfo uriInfo, @Parameter(description="Status of the target relationship: pending, confirmed or all") @QueryParam(value="status") String status, @Parameter(description="Identity id which is a UUID") @QueryParam(value="identityId") String identityId, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of relationships or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws WebApplicationException {
        List relationships;
        Relationship.Type type;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        try {
            type = Relationship.Type.valueOf((String)status.toUpperCase());
        }
        catch (Exception e) {
            type = Relationship.Type.ALL;
        }
        int size = 0;
        if (identityId != null && RestUtils.isMemberOfAdminGroup()) {
            Identity identity = this.identityManager.getIdentity(identityId);
            if (identity == null) {
                throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
            }
            relationships = this.relationshipManager.getRelationshipsByStatus(identity, type, offset, limit);
            if (returnSize) {
                size = this.relationshipManager.getRelationshipsCountByStatus(identity, type);
            }
        } else {
            String currentUser = this.getCurrentUserName();
            Identity authenticatedUser = this.getUserIdentity(currentUser);
            relationships = this.relationshipManager.getRelationshipsByStatus(authenticatedUser, type, offset, limit);
            if (returnSize) {
                size = this.relationshipManager.getRelationshipsCountByStatus(authenticatedUser, type);
            }
        }
        List<DataEntity> relationshipEntities = EntityBuilder.buildRelationshipEntities(relationships, uriInfo);
        CollectionEntity collectionRelationship = new CollectionEntity(relationshipEntities, "relationships", offset, limit);
        collectionRelationship.setSize(size);
        Response.ResponseBuilder builder = EntityBuilder.getResponseBuilder(collectionRelationship, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        CacheControl cc = new CacheControl();
        cc.setNoStore(true);
        builder.cacheControl(cc);
        return builder.build();
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a relationship", method="POST", description="This creates the relationship in the following cases: <br/><ul><li>the authenticated user has permissions to view the 2 objects linked to the 2 identities</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="204", description="Request fulfilled and no content"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response createRelationship(@Context UriInfo uriInfo, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Relationship object to be created", required=true) RelationshipEntity model) throws WebApplicationException {
        if (model == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String senderRemoteId = model.getSender();
        String receiverRemoteId = model.getReceiver();
        if (StringUtils.isBlank((CharSequence)senderRemoteId) || StringUtils.isBlank((CharSequence)receiverRemoteId)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Relationship.Type type = Relationship.Type.valueOf((String)model.getStatus().toUpperCase());
        if (type != Relationship.Type.PENDING && type != Relationship.Type.IGNORED) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = this.getCurrentUserName();
        if (StringUtils.equals((CharSequence)receiverRemoteId, (CharSequence)authenticatedUser)) {
            String temp = receiverRemoteId;
            receiverRemoteId = senderRemoteId;
            senderRemoteId = temp;
        }
        if (!StringUtils.equals((CharSequence)senderRemoteId, (CharSequence)authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity receiver = this.getUserIdentity(receiverRemoteId);
        Identity currentSenderIdentity = this.getUserIdentity(senderRemoteId);
        if (receiver == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (type == Relationship.Type.PENDING) {
            Relationship relationship = this.relationshipManager.inviteToConnect(currentSenderIdentity, receiver);
            return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, true), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        if (type == Relationship.Type.IGNORED) {
            Relationship relationship = this.relationshipManager.ignore(currentSenderIdentity, receiver);
            return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        throw new WebApplicationException(Response.Status.UNAUTHORIZED);
    }

    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific relationship by id", method="GET", description="This returns the relationship if the authenticated user has permissions to view the objects linked to this relationship.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getRelationshipById(@Context UriInfo uriInfo, @Parameter(description="Relationship id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws WebApplicationException {
        Identity authenticatedUser = this.getUserIdentity(this.getCurrentUserName());
        Relationship relationship = this.relationshipManager.get(id);
        if (relationship == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.isUserInRelationship(relationship, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, true), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific relationship by id", method="PUT", description="This updates the relationship if the authenticated user has permissions to view the objects linked to this relationship.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="204", description="Request fulfilled with no content"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateRelationshipById(@Context UriInfo uriInfo, @Parameter(description="Relationship id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Relationship object to be updated", required=true) RelationshipEntity model) throws WebApplicationException {
        if (model == null || StringUtils.isBlank((CharSequence)model.getStatus())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Relationship relationship = this.relationshipManager.get(id);
        if (relationship == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (StringUtils.isNotBlank((CharSequence)model.getReceiver()) && StringUtils.isNotBlank((CharSequence)model.getSender()) && !this.isUserInRelationship(model, this.getCurrentUserName())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Relationship.Type type = Relationship.Type.valueOf((String)model.getStatus().toUpperCase());
        return this.updateRelationship(relationship, type, uriInfo, expand);
    }

    @PUT
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific relationship by provided model", method="PUT", description="This updates the relationship if the authenticated user has permissions to view the objects linked to this relationship.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="204", description="Request fulfilled with no content"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateRelationship(@Context UriInfo uriInfo, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Relationship object to be updated", required=true) RelationshipEntity model) throws WebApplicationException {
        if (model == null || StringUtils.isBlank((CharSequence)model.getStatus()) || StringUtils.isBlank((CharSequence)model.getSender()) || StringUtils.isBlank((CharSequence)model.getReceiver())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Identity sender = this.identityManager.getOrCreateUserIdentity(model.getSender());
        Identity receiver = this.identityManager.getOrCreateUserIdentity(model.getReceiver());
        if (sender == null || receiver == null || StringUtils.equals((CharSequence)receiver.getId(), (CharSequence)sender.getId())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Relationship.Type type = Relationship.Type.valueOf((String)model.getStatus().toUpperCase());
        Relationship relationship = this.relationshipManager.get(sender, receiver);
        if (relationship == null) {
            if (type == Relationship.Type.IGNORED) {
                relationship = this.relationshipManager.ignore(sender, receiver);
                return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return this.updateRelationship(relationship, type, uriInfo, expand);
    }

    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a specific relationship by id", method="DELETE", description="This deletes the relationship if the authenticated user has permissions to view the objects linked to this relationship.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response deleteRelationshipById(@Parameter(description="Relationship id", required=true) @PathParam(value="id") String id) throws WebApplicationException {
        Relationship relationship = this.relationshipManager.get(id);
        if (relationship == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return this.deleteRelationship(relationship);
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a specific relationship by id", method="DELETE", description="This deletes the relationship if the authenticated user has permissions to view the objects linked to this relationship.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response deleteRelationship(@RequestBody(description="Relationship object to be updated", required=true) RelationshipEntity model) throws WebApplicationException {
        if (model == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String senderRemoteId = model.getSender();
        String receiverRemoteId = model.getReceiver();
        if (StringUtils.isBlank((CharSequence)senderRemoteId) || StringUtils.isBlank((CharSequence)receiverRemoteId)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Identity sender = this.getUserIdentity(senderRemoteId);
        Identity receiver = this.getUserIdentity(receiverRemoteId);
        Relationship relationship = this.relationshipManager.get(sender, receiver);
        return this.deleteRelationship(relationship);
    }

    private Response updateRelationship(Relationship relationship, Relationship.Type type, UriInfo uriInfo, String expand) {
        String currentUserName = this.getCurrentUserName();
        Identity authenticatedUserIdentity = this.getUserIdentity(currentUserName);
        if (!this.isUserInRelationship(relationship, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (relationship.getStatus() == type) {
            return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, true), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        if (type.equals((Object)Relationship.Type.IGNORED)) {
            relationship = this.relationshipManager.ignore(relationship.getSender(), relationship.getReceiver());
            return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        if (type.equals((Object)Relationship.Type.PENDING)) {
            if (this.isSender(relationship, authenticatedUserIdentity)) {
                relationship = this.relationshipManager.inviteToConnect(relationship.getSender(), relationship.getReceiver());
            } else if (this.isReceiver(relationship, authenticatedUserIdentity)) {
                relationship = this.relationshipManager.inviteToConnect(relationship.getReceiver(), relationship.getSender());
            }
            return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, true), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        if (type.equals((Object)Relationship.Type.CONFIRMED)) {
            if (!StringUtils.equals((CharSequence)relationship.getReceiver().getRemoteId(), (CharSequence)currentUserName)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            relationship = this.relationshipManager.confirm(relationship.getSender(), relationship.getReceiver());
            return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    private Response deleteRelationship(Relationship relationship) {
        String authenticatedUser = this.getCurrentUserName();
        if (relationship == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (StringUtils.equals((CharSequence)relationship.getReceiver().getRemoteId(), (CharSequence)authenticatedUser)) {
            this.relationshipManager.deny(relationship.getReceiver(), relationship.getSender());
        } else if (StringUtils.equals((CharSequence)relationship.getSender().getRemoteId(), (CharSequence)authenticatedUser)) {
            this.relationshipManager.delete(relationship);
        } else {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return Response.noContent().build();
    }

    private boolean isUserInRelationship(Relationship relationship, Identity authenticatedUserIdentity) {
        return this.isSender(relationship, authenticatedUserIdentity) || this.isReceiver(relationship, authenticatedUserIdentity);
    }

    private boolean isSender(Relationship relationship, Identity authenticatedUserIdentity) {
        return StringUtils.equals((CharSequence)relationship.getSender().getId(), (CharSequence)authenticatedUserIdentity.getId());
    }

    private boolean isReceiver(Relationship relationship, Identity authenticatedUserIdentity) {
        return StringUtils.equals((CharSequence)relationship.getReceiver().getId(), (CharSequence)authenticatedUserIdentity.getId());
    }

    private boolean isUserInRelationship(RelationshipEntity model, String authenticatedUser) {
        return StringUtils.equals((CharSequence)model.getSender(), (CharSequence)authenticatedUser) || StringUtils.equals((CharSequence)model.getReceiver(), (CharSequence)authenticatedUser);
    }

    private Identity getUserIdentity(String currentUserName) {
        return this.identityManager.getOrCreateUserIdentity(currentUserName);
    }

    private String getCurrentUserName() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }
}

