/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.services;

import io.meeds.crowdin.gamification.model.RemoteApproval;
import io.meeds.crowdin.gamification.model.RemoteDirectory;
import io.meeds.crowdin.gamification.model.RemoteProject;
import io.meeds.crowdin.gamification.model.WebHook;
import io.meeds.crowdin.gamification.storage.CrowdinConsumerStorage;
import io.meeds.crowdin.gamification.storage.WebHookStorage;
import io.meeds.gamification.utils.Utils;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebhookService {
    public static final String NOT_FOUND = " wasn't found";
    @Autowired
    private CrowdinConsumerStorage crowdinConsumerStorage;
    @Autowired
    private WebHookStorage webHookStorage;

    public List<RemoteProject> getProjectsFromWebhookId(long webHookId) throws IllegalAccessException, ObjectNotFoundException {
        WebHook webHook = this.webHookStorage.getWebHookById(webHookId);
        if (webHook == null) {
            throw new ObjectNotFoundException("webhook with id : " + webHookId + NOT_FOUND);
        }
        return this.crowdinConsumerStorage.getProjects(webHook.getToken());
    }

    public List<RemoteProject> getProjects(String accessToken) throws IllegalAccessException {
        return this.crowdinConsumerStorage.getProjects(accessToken);
    }

    public RemoteApproval getApproval(String projectId, String translationId) {
        WebHook webHook = this.webHookStorage.getWebhookByProjectId(Long.parseLong(projectId));
        if (webHook != null) {
            return this.crowdinConsumerStorage.getApproval(webHook.getToken(), projectId, translationId);
        }
        return null;
    }

    public WebHook createWebhook(long projectId, String projectName, String accessToken, String currentUser) throws ObjectAlreadyExistsException, IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to create Crowdin hook");
        }
        WebHook existsWebHook = this.webHookStorage.getWebhookByProjectId(projectId);
        if (existsWebHook != null) {
            throw new ObjectAlreadyExistsException((Object)existsWebHook);
        }
        WebHook webHook = this.crowdinConsumerStorage.createWebhook(projectId, io.meeds.crowdin.gamification.utils.Utils.CROWDIN_EVENTS, accessToken);
        if (webHook != null) {
            webHook.setProjectName(projectName);
            webHook.setWatchedBy(currentUser);
            return this.webHookStorage.saveWebHook(webHook);
        }
        return null;
    }

    public void updateWebHookAccessToken(long webHookId, String accessToken, String currentUser) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access crowdin Hooks");
        }
        if (webHookId <= 0L) {
            throw new IllegalArgumentException("webHook id must be positive");
        }
        WebHook webHook = this.webHookStorage.getWebHookById(webHookId);
        if (webHook == null) {
            throw new ObjectNotFoundException("webhook with id : " + webHookId + NOT_FOUND);
        }
        this.webHookStorage.updateWebHookAccessToken(webHookId, io.meeds.crowdin.gamification.utils.Utils.encode(accessToken));
    }

    public List<WebHook> getWebhooks(String currentUser, int offset, int limit, boolean forceUpdate) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access crowdin Hooks");
        }
        return this.getWebhooks(offset, limit, forceUpdate);
    }

    public WebHook deleteWebhook(long projectId, String currentUser) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to delete Crowdin hook");
        }
        WebHook webHook = this.webHookStorage.getWebhookByProjectId(projectId);
        if (webHook == null) {
            throw new ObjectNotFoundException("Crowdin hook for project id : " + projectId + NOT_FOUND);
        }
        String response = this.crowdinConsumerStorage.deleteWebhook(webHook);
        if (response != null) {
            return this.deleteWebhook(projectId);
        }
        return null;
    }

    public WebHook deleteWebhook(long projectId) {
        return this.webHookStorage.deleteWebHook(projectId);
    }

    public List<WebHook> getWebhooks(int offset, int limit, boolean forceUpdate) {
        if (forceUpdate) {
            this.forceUpdateWebhooks();
        }
        return this.getWebhooks(offset, limit);
    }

    public List<RemoteDirectory> getProjectDirectories(long remoteProjectId, String currentUser, int offset, int limit) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access project directories");
        }
        WebHook existsWebHook = this.webHookStorage.getWebhookByProjectId(remoteProjectId);
        if (existsWebHook == null) {
            throw new ObjectNotFoundException("Webhook with project id '" + remoteProjectId + "' doesn't exist");
        }
        return this.crowdinConsumerStorage.getProjectDirectories(remoteProjectId, offset, limit, existsWebHook.getToken());
    }

    public void forceUpdateWebhooks() {
        this.crowdinConsumerStorage.clearCache();
        List<WebHook> webHook = this.getWebhooks(0, -1);
        webHook.forEach(this::forceUpdateWebhook);
    }

    public List<WebHook> getWebhooks(int offset, int limit) {
        return this.webHookStorage.getWebhooks(offset, limit);
    }

    public WebHook getWebhookId(long webhookId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)username)) {
            throw new IllegalAccessException("The user is not authorized to access crowdin Hooks");
        }
        WebHook webHook = this.getWebhookId(webhookId);
        if (webHook == null) {
            throw new ObjectNotFoundException("Webhook doesn't exist");
        }
        return webHook;
    }

    public WebHook getWebhookId(long webhookId) {
        if (webhookId <= 0L) {
            throw new IllegalArgumentException("Webhook id is mandatory");
        }
        return this.webHookStorage.getWebHookById(webhookId);
    }

    private void forceUpdateWebhook(WebHook webHook) {
    }
}

