/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.rest;

import io.meeds.notes.model.TermsAndConditionPage;
import io.meeds.notes.service.TermsAndConditionsService;
import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.utils.HtmlUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.LocaleUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.rest.api.RestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"terms"})
@Tag(name="terms", description="Managing terms and conditions")
public class TermsAndConditionsRest {
    private static final Log LOG = ExoLogger.getLogger(TermsAndConditionsRest.class);
    @Autowired
    private TermsAndConditionsService termsAndConditionsService;

    @GetMapping
    @Secured(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves the terms and conditions page", description="Retrieves the terms and conditions page", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="304", description="Not modified"), @ApiResponse(responseCode="404", description="Resource not found")})
    public ResponseEntity<TermsAndConditionPage> getTermsAndConditionPage(HttpServletRequest request, @Parameter(description="User language") @RequestParam(value="lang") String lang) {
        TermsAndConditionPage termsAndConditionPage = this.termsAndConditionsService.getTermsAndConditions(lang);
        if (termsAndConditionPage == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        termsAndConditionPage.setContent(this.transformContent(termsAndConditionPage.getContent(), lang));
        String eTagValue = String.valueOf(termsAndConditionPage.hashCode());
        String requestETag = request.getHeader("If-None-Match");
        if (requestETag != null && requestETag.equals(eTagValue)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_MODIFIED).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(eTagValue)).body((Object)termsAndConditionPage);
    }

    @PutMapping
    @Secured(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Saves a terms and conditions page content", description="Saves a terms and conditions page content", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized")})
    public TermsAndConditionPage saveTermsAndConditions(@Parameter(description="Note Content", required=true) @RequestParam(value="content") String content, @Parameter(description="User language") @RequestParam(value="lang") String lang) {
        try {
            return this.termsAndConditionsService.saveTermsAndConditions(content, lang, RestUtils.getCurrentUserAclIdentity());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }

    @PutMapping(path={"/settings"})
    @Secured(value={"users"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Update terms and conditions settings", description="Updates the settings for the terms and conditions page", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad Request")})
    public TermsAndConditionPage updateTermsAndConditionsSettings(@Parameter(description="Whether the terms and conditions update is a publish or not") @RequestParam(name="published") Optional<Boolean> published, @Parameter(description="User language") @RequestParam(value="lang") String lang) {
        try {
            return this.termsAndConditionsService.updateTermsAndConditionsSettings(published.orElse(true), lang, RestUtils.getCurrentUserAclIdentity());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    @PostMapping(path={"/accept"})
    @Secured(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Accept terms and conditions", description="Marks the terms and conditions as accepted for the current user", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Terms accepted successfully"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    public void acceptTermsAndConditions(HttpServletRequest request, @Parameter(description="User language") @RequestParam(value="lang") String lang) {
        this.termsAndConditionsService.markTermsAsAcceptedForUser(request.getRemoteUser(), lang);
    }

    @GetMapping(path={"/status"})
    @Secured(value={"users"})
    @Produces(value={"text/plain"})
    @Operation(summary="Check terms and conditions status for the current user", description="Check the terms and conditions status for the current user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized")})
    public boolean isTermsAcceptedForUser(HttpServletRequest request, @Parameter(description="User language") @RequestParam(value="lang") String lang) {
        return this.termsAndConditionsService.isTermsAcceptedForUser(request.getRemoteUser(), lang);
    }

    private String transformContent(String content, String lang) {
        try {
            content = HtmlUtils.transform((String)content, (HtmlTransformerContext)new HtmlTransformerContext(ConversationState.getCurrent().getIdentity(), LocaleUtils.toLocale((String)lang)));
            return HTMLSanitizer.sanitize((String)content);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error sanitizing terms and conditions content", (Throwable)e);
            return content;
        }
    }
}

