/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.annotation.server;

import jakarta.servlet.ServletException;
import java.util.ArrayList;
import java.util.List;
import org.cometd.annotation.server.ServerAnnotationProcessor;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.server.CometDServlet;
import org.eclipse.jetty.util.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationCometDServlet
extends CometDServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationCometDServlet.class);
    private final List<Object> services = new ArrayList<Object>();
    private volatile ServerAnnotationProcessor processor;

    public void init() throws ServletException {
        super.init();
        this.processor = this.newServerAnnotationProcessor((BayeuxServer)this.getBayeux());
        String servicesParam = this.getInitParameter("services");
        if (servicesParam != null && servicesParam.length() > 0) {
            for (String serviceClass : servicesParam.split(",")) {
                Object service = this.processService(this.processor, serviceClass.trim());
                this.services.add(service);
                this.registerService(service);
            }
        }
    }

    protected ServerAnnotationProcessor newServerAnnotationProcessor(BayeuxServer bayeuxServer) {
        return new ServerAnnotationProcessor(bayeuxServer);
    }

    protected Object processService(ServerAnnotationProcessor processor, String serviceClassName) throws ServletException {
        try {
            Object service = this.newService(serviceClassName);
            processor.process(service);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processed annotated service {}", service);
            }
            return service;
        }
        catch (Exception x) {
            LOGGER.warn("Failed to create annotated service " + serviceClassName, (Throwable)x);
            throw new ServletException((Throwable)x);
        }
    }

    protected Object newService(String serviceClassName) throws Exception {
        Class serviceClass = Loader.loadClass(((Object)((Object)this)).getClass(), (String)serviceClassName);
        return serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void registerService(Object service) {
        this.getServletContext().setAttribute(service.getClass().getName(), service);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered annotated service {} in servlet context", service);
        }
    }

    public void destroy() {
        for (Object service : this.services) {
            this.deregisterService(service);
            this.deprocessService(this.processor, service);
        }
        super.destroy();
    }

    protected void deregisterService(Object service) {
        this.getServletContext().removeAttribute(service.getClass().getName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deregistered annotated service {}", service);
        }
    }

    protected void deprocessService(ServerAnnotationProcessor processor, Object service) {
        processor.deprocess(service);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deprocessed annotated service {}", service);
        }
    }

    public List<Object> getServices() {
        return this.services;
    }
}

