/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.registry;

import io.meeds.oauth.principal.DefaultPrincipalProcessor;
import io.meeds.oauth.spi.AccessTokenContext;
import io.meeds.oauth.spi.OAuthPrincipalProcessor;
import io.meeds.oauth.spi.OAuthProviderProcessor;
import io.meeds.oauth.spi.OAuthProviderType;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.gatein.common.classloader.DelegatingClassLoader;

public class OauthProviderTypeRegistryPlugin<T extends AccessTokenContext>
extends BaseComponentPlugin {
    private final OAuthProviderType oauthPrType;

    public OauthProviderTypeRegistryPlugin(InitParams params, ExoContainerContext containerContext) throws Exception {
        String key = this.getParam(params, "key");
        String enabledPar = this.getParam(params, "enabled");
        String usernameAttributeName = this.getParam(params, "userNameAttributeName");
        String oauthProviderProcessorClass = this.getParam(params, "oauthProviderProcessorClass");
        String principalProcessorClassName = null;
        ValueParam param = params.getValueParam("principalProcessorClass");
        if (param != null) {
            principalProcessorClassName = param.getValue();
        }
        String initOAuthURL = this.getParam(params, "initOAuthURL");
        String friendlyName = this.getParam(params, "friendlyName");
        boolean enabled = Boolean.parseBoolean(enabledPar);
        if (enabled) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            ClassLoader oauth = OAuthProviderType.class.getClassLoader();
            DelegatingClassLoader delegating = new DelegatingClassLoader(new ClassLoader[]{tccl, oauth});
            Class<?> processorClass = delegating.loadClass(oauthProviderProcessorClass);
            OAuthProviderProcessor oauthProviderProcessor = (OAuthProviderProcessor)containerContext.getContainer().getComponentInstanceOfType(processorClass);
            OAuthPrincipalProcessor principalProcessor = null;
            Class<DefaultPrincipalProcessor> principalProcessorClass = principalProcessorClassName != null ? delegating.loadClass(principalProcessorClassName) : DefaultPrincipalProcessor.class;
            principalProcessor = (OAuthPrincipalProcessor)containerContext.getContainer().getComponentInstanceOfType(principalProcessorClass);
            if (principalProcessor == null) {
                principalProcessor = (OAuthPrincipalProcessor)principalProcessorClass.newInstance();
            }
            this.oauthPrType = new OAuthProviderType(key, enabled, usernameAttributeName, oauthProviderProcessor, principalProcessor, initOAuthURL, friendlyName);
        } else {
            this.oauthPrType = null;
        }
    }

    OAuthProviderType getOAuthProviderType() {
        return this.oauthPrType;
    }

    private String getParam(InitParams params, String paramName) {
        ValueParam param = params.getValueParam(paramName);
        if (param == null) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' needs to be provided");
        }
        return param.getValue();
    }
}

