/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.exoplatform.common.http.client.HashVerifier;

class MD5InputStream
extends FilterInputStream {
    private HashVerifier verifier;
    private MessageDigest md5;
    private long rcvd = 0L;
    private boolean closed = false;

    public MD5InputStream(InputStream is, HashVerifier verifier) {
        super(is);
        this.verifier = verifier;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new Error(nsae.toString(), nsae);
        }
    }

    @Override
    public synchronized int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.md5.update((byte)b);
        } else {
            this.real_close();
        }
        ++this.rcvd;
        return b;
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int num = this.in.read(buf, off, len);
        if (num > 0) {
            this.md5.update(buf, off, num);
        } else {
            this.real_close();
        }
        this.rcvd += (long)num;
        return num;
    }

    @Override
    public synchronized long skip(long num) throws IOException {
        byte[] tmp = new byte[(int)num];
        int got = this.read(tmp, 0, (int)num);
        if (got > 0) {
            return got;
        }
        return 0L;
    }

    @Override
    public synchronized void close() throws IOException {
        while (this.skip(10000L) > 0L) {
        }
        this.real_close();
    }

    private void real_close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.in.close();
        this.verifier.verifyHash(this.md5.digest(), this.rcvd);
    }
}

