/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.jpa.web;

import jakarta.persistence.RollbackException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure1;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure11;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure13;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure15;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure17;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure19;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure21;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure23;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure25;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure27;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure3;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure5;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure7;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage$AjcClosure9;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebNotifDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebParamsDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebNotifEntity;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebParamsEntity;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebUsersEntity;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JPAWebNotificationStorage
implements WebNotificationStorage {
    private static final Log LOG;
    private final UserSettingService userSettingService;
    private WebNotifDAO webNotifDAO;
    private WebParamsDAO webParamsDAO;
    private WebUsersDAO webUsersDAO;
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public JPAWebNotificationStorage(WebNotifDAO webNotifDAO, WebParamsDAO webParamsDAO, WebUsersDAO webUsersDAO, UserSettingService userSettingService, ListenerService listenerService) {
        this.userSettingService = userSettingService;
        this.webNotifDAO = webNotifDAO;
        this.webParamsDAO = webParamsDAO;
        this.webUsersDAO = webUsersDAO;
        this.listenerService = listenerService;
    }

    @ExoTransactional
    public void save(NotificationInfo notification) {
        NotificationInfo notificationInfo = notification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)notificationInfo);
        Object[] objectArray = new Object[]{this, notificationInfo, joinPoint};
        JPAWebNotificationStorage$AjcClosure1 jPAWebNotificationStorage$AjcClosure1 = new JPAWebNotificationStorage$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<NotificationInfo> get(WebNotificationFilter filter, int offset, int limit) {
        WebNotificationFilter webNotificationFilter = filter;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{webNotificationFilter, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, webNotificationFilter, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        JPAWebNotificationStorage$AjcClosure3 jPAWebNotificationStorage$AjcClosure3 = new JPAWebNotificationStorage$AjcClosure3(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public NotificationInfo get(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        JPAWebNotificationStorage$AjcClosure5 jPAWebNotificationStorage$AjcClosure5 = new JPAWebNotificationStorage$AjcClosure5(objectArray);
        return (NotificationInfo)ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public boolean remove(String notificationId) {
        String string = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        JPAWebNotificationStorage$AjcClosure7 jPAWebNotificationStorage$AjcClosure7 = new JPAWebNotificationStorage$AjcClosure7(objectArray);
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure7.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public boolean remove(long seconds) {
        long l = seconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        JPAWebNotificationStorage$AjcClosure9 jPAWebNotificationStorage$AjcClosure9 = new JPAWebNotificationStorage$AjcClosure9(objectArray);
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure9.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public boolean remove(String userId, long seconds) {
        String string = userId;
        long l = seconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, string, Conversions.longObject((long)l), joinPoint};
        JPAWebNotificationStorage$AjcClosure11 jPAWebNotificationStorage$AjcClosure11 = new JPAWebNotificationStorage$AjcClosure11(objectArray);
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure11.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public void markRead(String notificationId) {
        String string = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        JPAWebNotificationStorage$AjcClosure13 jPAWebNotificationStorage$AjcClosure13 = new JPAWebNotificationStorage$AjcClosure13(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void hidePopover(String notificationId) {
        String string = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        JPAWebNotificationStorage$AjcClosure15 jPAWebNotificationStorage$AjcClosure15 = new JPAWebNotificationStorage$AjcClosure15(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void markAllRead(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        JPAWebNotificationStorage$AjcClosure17 jPAWebNotificationStorage$AjcClosure17 = new JPAWebNotificationStorage$AjcClosure17(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    public void markAllRead(List<String> plugins, String username) {
        List<WebUsersEntity> notifsWithBadge = this.webUsersDAO.findUnreadByUserAndPlugins(plugins, username);
        if (CollectionUtils.isNotEmpty(notifsWithBadge)) {
            notifsWithBadge.forEach(n -> {
                n.setResetNumberOnBadge(true);
                n.setRead(true);
            });
            this.webUsersDAO.updateAll(notifsWithBadge);
            notifsWithBadge.forEach(n -> this.listenerService.broadcast("notification.web.read", (Object)String.valueOf(n.getId()), null));
        }
    }

    @ExoTransactional
    public NotificationInfo getUnreadNotification(String pluginId, String activityId, String userId) {
        String string = pluginId;
        String string2 = activityId;
        String string3 = userId;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        JPAWebNotificationStorage$AjcClosure19 jPAWebNotificationStorage$AjcClosure19 = new JPAWebNotificationStorage$AjcClosure19(objectArray2);
        return (NotificationInfo)ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void update(NotificationInfo notification, boolean moveTop) {
        NotificationInfo notificationInfo = notification;
        boolean bl = moveTop;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)notificationInfo, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, notificationInfo, Conversions.booleanObject((boolean)bl), joinPoint};
        JPAWebNotificationStorage$AjcClosure21 jPAWebNotificationStorage$AjcClosure21 = new JPAWebNotificationStorage$AjcClosure21(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure21.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public int getNumberOnBadge(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        JPAWebNotificationStorage$AjcClosure23 jPAWebNotificationStorage$AjcClosure23 = new JPAWebNotificationStorage$AjcClosure23(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure23.linkClosureAndJoinPoint(69648)));
    }

    public Map<String, Integer> countUnreadByPlugin(String userId) {
        return this.webUsersDAO.countUnreadByPlugin(userId);
    }

    @ExoTransactional
    public void resetNumberOnBadge(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        JPAWebNotificationStorage$AjcClosure25 jPAWebNotificationStorage$AjcClosure25 = new JPAWebNotificationStorage$AjcClosure25(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure25.linkClosureAndJoinPoint(69648));
    }

    public void resetNumberOnBadge(List<String> plugins, String username) {
        List<WebUsersEntity> notifsWithBadge = this.webUsersDAO.findNotifsWithBadgeByPlugins(plugins, username);
        if (CollectionUtils.isNotEmpty(notifsWithBadge)) {
            notifsWithBadge.forEach(n -> n.setResetNumberOnBadge(true));
            this.webUsersDAO.updateAll(notifsWithBadge);
        }
    }

    private void save(NotificationInfo notification, boolean moveTop) {
        WebUsersEntity webUsersEntity = null;
        if (notification.getId() != null && !notification.getId().startsWith("NotificationMessage")) {
            webUsersEntity = (WebUsersEntity)this.webUsersDAO.find(Long.valueOf(Long.parseLong(notification.getId())));
        }
        boolean isNew = webUsersEntity == null;
        WebNotifEntity webNotifEntity = null;
        if (isNew) {
            webNotifEntity = new WebNotifEntity();
            webUsersEntity = new WebUsersEntity();
        } else {
            webNotifEntity = webUsersEntity.getNotification();
        }
        webNotifEntity.setType(notification.getKey().getId());
        webNotifEntity.setText(notification.getTitle());
        webNotifEntity.setSender(notification.getFrom());
        if (webNotifEntity.getCreationDate() == null) {
            webNotifEntity.setCreationDate(Calendar.getInstance());
        }
        webNotifEntity = isNew ? (WebNotifEntity)this.webNotifDAO.create(webNotifEntity) : (WebNotifEntity)this.webNotifDAO.update(webNotifEntity);
        Map ownerParameters = notification.getOwnerParameter();
        this.updateNotificationParameters(webNotifEntity, ownerParameters, isNew);
        webUsersEntity.setReceiver(notification.getTo());
        Calendar calendar = Calendar.getInstance();
        if (moveTop) {
            webUsersEntity.setUpdateDate(calendar);
        } else if (notification.getLastModifiedDate() > 0L) {
            calendar.setTimeInMillis(notification.getLastModifiedDate());
            webUsersEntity.setUpdateDate(calendar);
        } else {
            webUsersEntity.setUpdateDate(webNotifEntity.getCreationDate());
        }
        webUsersEntity.setResetNumberOnBadge(notification.isResetOnBadge());
        if (ownerParameters != null && ownerParameters.containsKey(NotificationMessageUtils.READ_PORPERTY.getKey())) {
            webUsersEntity.setRead(Boolean.parseBoolean(((String)ownerParameters.get(NotificationMessageUtils.READ_PORPERTY.getKey())).toLowerCase()));
        } else {
            webUsersEntity.setRead(notification.isRead());
        }
        if (ownerParameters != null && ownerParameters.containsKey(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey())) {
            webUsersEntity.setShowPopover(Boolean.parseBoolean(((String)ownerParameters.get(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey())).toLowerCase()));
        } else {
            webUsersEntity.setShowPopover(notification.isOnPopOver());
        }
        webUsersEntity.setNotification(webNotifEntity);
        if (isNew) {
            webUsersEntity = (WebUsersEntity)this.webUsersDAO.create(webUsersEntity);
            notification.setId(String.valueOf(webUsersEntity.getId()));
        } else {
            this.webUsersDAO.update(webUsersEntity);
        }
        this.listenerService.broadcast("notification.web.saved", (Object)notification.getId(), (Object)isNew);
    }

    private void updateNotificationParameters(WebNotifEntity webNotifEntity, Map<String, String> ownerParameters, boolean isNew) {
        Set<WebParamsEntity> parameters = webNotifEntity.getParameters();
        if (ownerParameters != null && !ownerParameters.isEmpty()) {
            for (String propertyName : ownerParameters.keySet()) {
                WebParamsEntity webParamsEntity = null;
                boolean isParamNew = true;
                if (isNew) {
                    webParamsEntity = new WebParamsEntity();
                } else {
                    for (WebParamsEntity webParamsEntityTmp : parameters) {
                        if (!webParamsEntityTmp.getName().equals(propertyName)) continue;
                        webParamsEntity = webParamsEntityTmp;
                        isParamNew = false;
                        break;
                    }
                }
                if (webParamsEntity == null) {
                    webParamsEntity = new WebParamsEntity();
                }
                webParamsEntity.setName(propertyName);
                webParamsEntity.setValue(ownerParameters.get(propertyName));
                webParamsEntity.setNotification(webNotifEntity);
                if (isParamNew) {
                    this.webParamsDAO.create(webParamsEntity);
                    continue;
                }
                this.webParamsDAO.update(webParamsEntity);
            }
        }
    }

    private long parseNotificationId(String notificationId) {
        return Long.parseLong(notificationId);
    }

    @ExoTransactional
    private WebUsersEntity getWebNotification(Long notificationId) {
        Long l = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)l);
        Object[] objectArray = new Object[]{this, l, joinPoint};
        JPAWebNotificationStorage$AjcClosure27 jPAWebNotificationStorage$AjcClosure27 = new JPAWebNotificationStorage$AjcClosure27(objectArray);
        return (WebUsersEntity)ExoTransactionalAspect.aspectOf().around(jPAWebNotificationStorage$AjcClosure27.linkClosureAndJoinPoint(69648));
    }

    public NotificationInfo convertWebNotifEntityToNotificationInfo(WebUsersEntity webUsersEntity) {
        NotificationInfo notificationInfo = new NotificationInfo();
        WebNotifEntity notification = webUsersEntity.getNotification();
        notificationInfo.setLastModifiedDate(webUsersEntity.getUpdateDate());
        Set<WebParamsEntity> parameters = notification.getParameters();
        Map<String, String> ownerParameters = parameters.stream().collect(Collectors.toMap(WebParamsEntity::getName, value -> value.getValue() == null ? "" : value.getValue(), (v1, v2) -> v2));
        ownerParameters = new HashMap<String, String>(ownerParameters);
        ownerParameters.put(NotificationMessageUtils.READ_PORPERTY.getKey(), String.valueOf(webUsersEntity.isRead()));
        ownerParameters.put(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey(), String.valueOf(webUsersEntity.isShowPopover()));
        notificationInfo.setOwnerParameter(ownerParameters);
        notificationInfo.key(new PluginKey(notification.getType()));
        notificationInfo.setTitle(notification.getText());
        notificationInfo.setFrom(notification.getSender());
        notificationInfo.to(webUsersEntity.getReceiver());
        notificationInfo.setRead(webUsersEntity.isRead());
        notificationInfo.setOnPopOver(webUsersEntity.isShowPopover());
        notificationInfo.setResetOnBadge(webUsersEntity.isResetNumberOnBadge());
        notificationInfo.setDateCreated(notification.getCreationDate());
        notificationInfo.setId(String.valueOf(webUsersEntity.getId()));
        return notificationInfo;
    }

    static {
        JPAWebNotificationStorage.ajc$preClinit();
        LOG = ExoLogger.getLogger(JPAWebNotificationStorage.class);
    }

    static final /* synthetic */ void save_aroundBody0(JPAWebNotificationStorage ajc$this, NotificationInfo notification, JoinPoint joinPoint) {
        ajc$this.save(notification, false);
    }

    static final /* synthetic */ List get_aroundBody2(JPAWebNotificationStorage ajc$this, WebNotificationFilter filter, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.webUsersDAO.findWebNotificationsByFilter(filter, offset, limit).stream().map(n -> {
            try {
                return this.convertWebNotifEntityToNotificationInfo((WebUsersEntity)n);
            }
            catch (Exception e) {
                LOG.warn("Error while converting Web Notification Entity {} to DTO", new Object[]{n, e});
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    static final /* synthetic */ NotificationInfo get_aroundBody4(JPAWebNotificationStorage ajc$this, String id, JoinPoint joinPoint) {
        if (StringUtils.isBlank((CharSequence)id) || id.startsWith("NotificationMessage")) {
            return null;
        }
        WebUsersEntity webUsersEntity = ajc$this.getWebNotification(ajc$this.parseNotificationId(id));
        if (webUsersEntity != null) {
            return ajc$this.convertWebNotifEntityToNotificationInfo(webUsersEntity);
        }
        return null;
    }

    static final /* synthetic */ boolean remove_aroundBody6(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint joinPoint) {
        WebUsersEntity webUsersEntity = ajc$this.getWebNotification(ajc$this.parseNotificationId(notificationId));
        if (webUsersEntity != null) {
            ajc$this.webUsersDAO.delete(webUsersEntity);
            ajc$this.listenerService.broadcast("notification.web.deleted", (Object)notificationId, null);
            return true;
        }
        return false;
    }

    static final /* synthetic */ boolean remove_aroundBody8(JPAWebNotificationStorage ajc$this, long seconds, JoinPoint joinPoint) {
        Calendar cal = Calendar.getInstance();
        long delayTime = System.currentTimeMillis() - seconds * 1000L;
        cal.setTimeInMillis(delayTime);
        int webUserNotisCount = ajc$this.webUsersDAO.countWebNotifsByLastUpdatedDate(cal);
        int processedNotifs = 0;
        int batch = 100;
        ArrayList<WebNotifEntity> notifEntities = new ArrayList<WebNotifEntity>();
        while (webUserNotisCount > processedNotifs) {
            List<WebUsersEntity> webUserNotifs = ajc$this.webUsersDAO.findWebNotifsByLastUpdatedDate(cal, -1, batch);
            for (WebUsersEntity webUsersEntity : webUserNotifs) {
                WebNotifEntity notification = webUsersEntity.getNotification();
                if (!notifEntities.contains(notification)) {
                    notifEntities.add(notification);
                }
                ajc$this.webUsersDAO.delete(webUsersEntity);
                ++processedNotifs;
                ajc$this.listenerService.broadcast("notification.web.deleted", (Object)String.valueOf(notification.getId()), null);
            }
            if (notifEntities.isEmpty() || notifEntities.size() < 100 && webUserNotisCount != processedNotifs) continue;
            for (WebNotifEntity webNotifEntity : notifEntities) {
                try {
                    ajc$this.webNotifDAO.delete((WebNotifEntity)ajc$this.webNotifDAO.find(Long.valueOf(webNotifEntity.getId())));
                }
                catch (RollbackException rollbackException) {
                    LOG.warn("Could not deleting the notification {}, proceeding to delete the following one", new Object[]{webNotifEntity.getId()});
                }
            }
            RequestLifeCycle.restartTransaction();
            notifEntities = new ArrayList();
            LOG.info("Deleted {} / {} web notifications of users", new Object[]{processedNotifs, webUserNotisCount});
        }
        return false;
    }

    static final /* synthetic */ boolean remove_aroundBody10(JPAWebNotificationStorage ajc$this, String userId, long seconds, JoinPoint joinPoint) {
        Calendar calendar = Calendar.getInstance();
        long timeInMilliseconds = calendar.getTimeInMillis() - seconds * 1000L;
        calendar.setTimeInMillis(timeInMilliseconds);
        boolean removed = false;
        for (WebUsersEntity webUsersEntity : ajc$this.webUsersDAO.findWebNotifsOfUserByLastUpdatedDate(userId, calendar)) {
            try {
                ajc$this.webUsersDAO.delete(webUsersEntity);
                removed = true;
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to remove notification with id '" + webUsersEntity.getId() + "' for the user id: " + userId), (Throwable)e);
                return false;
            }
        }
        return removed;
    }

    static final /* synthetic */ void markRead_aroundBody12(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint joinPoint) {
        long notifIdLong = ajc$this.parseNotificationId(notificationId);
        WebUsersEntity webUsersEntity = (WebUsersEntity)ajc$this.webUsersDAO.find(Long.valueOf(notifIdLong));
        if (webUsersEntity != null) {
            webUsersEntity.setRead(true);
            webUsersEntity.setResetNumberOnBadge(true);
            webUsersEntity = (WebUsersEntity)ajc$this.webUsersDAO.update(webUsersEntity);
            ajc$this.listenerService.broadcast("notification.web.read", (Object)notificationId, null);
            NotificationInfo notification = ajc$this.get(notificationId);
            Map ownerParameters = notification.getOwnerParameter();
            ownerParameters.put(NotificationMessageUtils.READ_PORPERTY.getKey(), String.valueOf(webUsersEntity.isRead()));
            ajc$this.updateNotificationParameters(webUsersEntity.getNotification(), ownerParameters, false);
        }
    }

    static final /* synthetic */ void hidePopover_aroundBody14(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint joinPoint) {
        WebUsersEntity webUsersEntity = (WebUsersEntity)ajc$this.webUsersDAO.find(Long.valueOf(ajc$this.parseNotificationId(notificationId)));
        if (webUsersEntity != null) {
            webUsersEntity.setShowPopover(false);
            webUsersEntity.setRead(true);
            webUsersEntity.setResetNumberOnBadge(true);
            webUsersEntity = (WebUsersEntity)ajc$this.webUsersDAO.update(webUsersEntity);
            NotificationInfo notification = ajc$this.get(notificationId);
            Map ownerParameters = notification.getOwnerParameter();
            ownerParameters.put(NotificationMessageUtils.READ_PORPERTY.getKey(), String.valueOf(webUsersEntity.isRead()));
            ownerParameters.put(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey(), String.valueOf(webUsersEntity.isShowPopover()));
            ajc$this.updateNotificationParameters(webUsersEntity.getNotification(), ownerParameters, false);
        }
    }

    static final /* synthetic */ void markAllRead_aroundBody16(JPAWebNotificationStorage ajc$this, String username, JoinPoint joinPoint) {
        ajc$this.webUsersDAO.markAllRead(username);
        ajc$this.userSettingService.saveLastReadDate(username, Long.valueOf(System.currentTimeMillis()));
        ajc$this.listenerService.broadcast("notification.web.readAll", (Object)username, null);
    }

    static final /* synthetic */ NotificationInfo getUnreadNotification_aroundBody18(JPAWebNotificationStorage ajc$this, String pluginId, String activityId, String userId, JoinPoint joinPoint) {
        List<WebUsersEntity> list = ajc$this.webUsersDAO.findUnreadNotification(pluginId, userId, "activityId", activityId);
        if (!list.isEmpty()) {
            WebUsersEntity webUsersNotification = list.get(0);
            return ajc$this.convertWebNotifEntityToNotificationInfo(webUsersNotification);
        }
        return null;
    }

    static final /* synthetic */ void update_aroundBody20(JPAWebNotificationStorage ajc$this, NotificationInfo notification, boolean moveTop, JoinPoint joinPoint) {
        ajc$this.save(notification, moveTop);
    }

    static final /* synthetic */ int getNumberOnBadge_aroundBody22(JPAWebNotificationStorage ajc$this, String userId, JoinPoint joinPoint) {
        return ajc$this.webUsersDAO.getNumberOnBadge(userId);
    }

    static final /* synthetic */ void resetNumberOnBadge_aroundBody24(JPAWebNotificationStorage ajc$this, String userId, JoinPoint joinPoint) {
        List<WebUsersEntity> notifsWithBadge = ajc$this.webUsersDAO.findNotifsWithBadge(userId);
        if (CollectionUtils.isNotEmpty(notifsWithBadge)) {
            for (WebUsersEntity webUsersEntity : notifsWithBadge) {
                webUsersEntity.setResetNumberOnBadge(true);
            }
            ajc$this.webUsersDAO.updateAll(notifsWithBadge);
        }
    }

    static final /* synthetic */ WebUsersEntity getWebNotification_aroundBody26(JPAWebNotificationStorage ajc$this, Long notificationId, JoinPoint joinPoint) {
        return (WebUsersEntity)ajc$this.webUsersDAO.find(notificationId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPAWebNotificationStorage.java", JPAWebNotificationStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "org.exoplatform.commons.api.notification.model.NotificationInfo", "notification", "", "void"), 74);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "org.exoplatform.commons.api.notification.model.WebNotificationFilter:int:int", "filter:offset:limit", "", "java.util.List"), 80);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "org.exoplatform.commons.api.notification.model.NotificationInfo:boolean", "notification:moveTop", "", "void"), 253);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNumberOnBadge", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "userId", "", "int"), 259);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resetNumberOnBadge", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "userId", "", "void"), 270);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getWebNotification", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.Long", "notificationId", "", "org.exoplatform.commons.notification.impl.jpa.web.entity.WebUsersEntity"), 401);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "id", "", "org.exoplatform.commons.api.notification.model.NotificationInfo"), 93);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "notificationId", "", "boolean"), 106);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "long", "seconds", "", "boolean"), 118);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String:long", "userId:seconds", "", "boolean"), 155);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "markRead", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "notificationId", "", "void"), 175);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hidePopover", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "notificationId", "", "void"), 196);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "markAllRead", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "username", "", "void"), 218);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnreadNotification", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String:java.lang.String:java.lang.String", "pluginId:activityId:userId", "", "org.exoplatform.commons.api.notification.model.NotificationInfo"), 239);
    }
}

