/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.job;

import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.job.NotificationJob;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class WebNotificationJob
extends NotificationJob {
    protected static final Log LOG = ExoLogger.getLogger(NotificationJob.class);

    public WebNotificationJob() {
        this((ExoContainer)PortalContainer.getInstance());
    }

    public WebNotificationJob(ExoContainer exoContainer) {
        super(exoContainer);
    }

    @Override
    protected void processSendNotification(JobExecutionContext context) throws Exception {
        WebNotificationStorage dataStorage = CommonsUtils.getService(WebNotificationStorage.class);
        long startTime = System.currentTimeMillis();
        long liveDays = this.getLiveTime(context.getJobDetail().getJobDataMap());
        ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
        dataStorage.remove(liveDays);
        LOG.info((Object)("Done clear web notifications for all users, time: " + (System.currentTimeMillis() - startTime) + "ms."));
    }

    private long getLiveTime(JobDataMap jdatamap) {
        long liveDays = 30L;
        try {
            liveDays = Long.valueOf(jdatamap.getString("liveDays"));
            if (liveDays <= 0L) {
                LOG.warn((Object)"The value of the propety exo.notification.viewall cannot be 0 or negative. Using the default instead: 30.");
                liveDays = 30L;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)String.format("The value of the propety exo.notification.viewall is incorrect:%s. Using the default instead: 30.", jdatamap.getString("liveDays")));
            liveDays = 30L;
        }
        return liveDays *= 86400L;
    }
}

