/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.job.mbeans;

import java.util.Calendar;
import org.exoplatform.commons.notification.job.mbeans.AbstractNotificationJobManager;
import org.exoplatform.commons.notification.job.mbeans.DailyService;
import org.exoplatform.commons.notification.job.mbeans.NotificationDigestJob;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

@Managed
@ManagedDescription(value="Daily Notification Job Manager")
@NameTemplate(value={@Property(key="service", value="notification"), @Property(key="view", value="DailyJob")})
public class DailyJobManager
extends AbstractNotificationJobManager {
    private DailyService service;
    private String CRON_EXPRESSION = "0 * 23 ? * *";

    public DailyJobManager(DailyService service) {
        this.service = service;
        this.service.setManagement(this);
    }

    @Managed
    @ManagedDescription(value="Return status of DailyJob is running or not.")
    @Impact(value=ImpactType.READ)
    public boolean isRunning() {
        return DailyService.isStarted();
    }

    @Managed
    @ManagedDescription(value="Turn off the DailyJob.")
    @Impact(value=ImpactType.READ)
    public void Stop() {
        try {
            if (this.job != null) {
                this.service.off();
                this.scheduler.deleteJob(this.job.getKey());
            }
        }
        catch (SchedulerException e) {
            LOG.warn((Object)e);
        }
    }

    @Managed
    @ManagedDescription(value="Set CronExpression for Job. E.g: '0 0-59/15 * ? * *' ")
    @Impact(value=ImpactType.READ)
    public void setCronExpression(String cronExpression) {
        this.CRON_EXPRESSION = cronExpression;
    }

    @Override
    public void startJob(int second) {
        try {
            this.service.on();
            StdSchedulerFactory sf = new StdSchedulerFactory();
            this.scheduler = sf.getScheduler();
            if (this.job != null) {
                this.scheduler.deleteJob(this.job.getKey());
            }
            Calendar cal = Calendar.getInstance();
            cal.add(13, second);
            JobDataMap data = new JobDataMap();
            data.put("digest", "daily");
            this.job = JobBuilder.newJob(NotificationDigestJob.class).withIdentity("dailyJob", "portal:DailyJob").usingJobData(data).build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger-dailyJob", "portal:DailyJob").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.CRON_EXPRESSION)).startAt(cal.getTime()).build();
            this.triggerKey = trigger.getKey();
            this.scheduler.scheduleJob(this.job, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            LOG.warn((Object)e);
        }
    }
}

