/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.plugin;

import io.meeds.github.gamification.model.Event;
import io.meeds.github.gamification.plugin.GithubTriggerPlugin;
import io.meeds.github.gamification.services.GithubTriggerService;
import io.meeds.github.gamification.utils.Utils;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestReviewTriggerPlugin
extends GithubTriggerPlugin {
    private static final String NAME = "pull_request_review";
    @Autowired
    private GithubTriggerService githubTriggerService;

    @PostConstruct
    public void init() {
        this.githubTriggerService.addPlugin(this);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public List<Event> getEvents(Map<String, Object> payload) {
        String pullState = Utils.extractSubItem(payload, "review", "state");
        if (pullState != null && pullState.equals("commented")) {
            return Collections.singletonList(new Event("reviewPullRequest", Utils.extractSubItem(payload, "review", "user", "login"), Utils.extractSubItem(payload, "review", "user", "login"), Utils.extractSubItem(payload, "review", "html_url"), "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        if (pullState != null && pullState.equals("approved")) {
            return Arrays.asList(new Event("pullRequestValidated", Utils.extractSubItem(payload, "pull_request", "user", "login"), Utils.extractSubItem(payload, "pull_request", "user", "login"), Utils.extractSubItem(payload, "review", "html_url"), "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")), new Event("validatePullRequest", Utils.extractSubItem(payload, "review", "user", "login"), Utils.extractSubItem(payload, "review", "user", "login"), Utils.extractSubItem(payload, "review", "html_url"), "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        return Collections.emptyList();
    }
}

