/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.aspects;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.common.io.IOTools;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.EventInfo;
import org.gatein.pc.api.info.EventingInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.container.PortletApplication;
import org.gatein.pc.portlet.container.PortletApplicationContext;
import org.gatein.pc.portlet.container.PortletContainer;
import org.gatein.pc.portlet.impl.info.ContainerTypeInfo;

public class EventPayloadInterceptor
extends PortletInvokerInterceptor {
    private static final Log log = ExoLogger.getLogger(EventPayloadInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        if (invocation instanceof EventInvocation) {
            EventInvocation eventInvocation = (EventInvocation)invocation;
            Serializable srcPayload = eventInvocation.getPayload();
            Serializable dstPayload = null;
            if (srcPayload != null) {
                PortletContainer container = (PortletContainer)invocation.getAttribute("PORTLET_CONTAINER");
                PortletApplication application = container.getPortletApplication();
                PortletApplicationContext applicationContext = application.getContext();
                ClassLoader applicationClassLoader = applicationContext.getClassLoader();
                String srcPayloadClassName = srcPayload.getClass().getName();
                boolean trace = log.isTraceEnabled();
                QName eventName = eventInvocation.getName();
                String containerId = container.getId();
                String applicationId = application.getId();
                PortletInfo info = container.getInfo();
                EventingInfo eventingInfo = info.getEventing();
                Map consumedEventInfos = eventingInfo.getConsumedEvents();
                EventInfo eventInfo = (EventInfo)consumedEventInfos.get(eventName);
                if (trace) {
                    log.trace((Object)("Attempt to obtain for event " + String.valueOf(eventName) + " its payload class " + srcPayloadClassName + " in the application " + applicationId + " for portlet " + String.valueOf(container.getInfo())));
                }
                Class<?> dstPayloadClass = null;
                if (eventInfo != null) {
                    ContainerTypeInfo typeInfo = (ContainerTypeInfo)eventInfo.getType();
                    if (typeInfo != null) {
                        dstPayloadClass = typeInfo.getType();
                        if (trace) {
                            log.trace((Object)("Obtained for event " + String.valueOf(eventName) + " its payload class " + dstPayloadClass.getName() + " declared by the portlet meta data " + containerId));
                        }
                    } else if (trace) {
                        log.trace((Object)("No type declared for event " + String.valueOf(eventName) + " declared by the portlet meta data " + containerId));
                    }
                }
                if (dstPayloadClass == null) {
                    if (trace) {
                        log.trace((Object)("No event meta data declared by portlet " + containerId + " for event " + String.valueOf(eventName) + " will attempt to load same class name from the application " + applicationId + " classloader"));
                    }
                    try {
                        dstPayloadClass = applicationClassLoader.loadClass(srcPayloadClassName);
                        if (trace) {
                            log.trace((Object)("Obtained matching event class " + dstPayloadClass.getName() + " in application " + applicationId + " for event " + String.valueOf(eventName)));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        return new ErrorResponse("The application " + applicationId + " does not have access to the event payload class" + srcPayloadClassName, (Throwable)e);
                    }
                    catch (NoClassDefFoundError e) {
                        return new ErrorResponse("The application " + applicationId + " does not have access to the event payload class" + srcPayloadClassName, (Throwable)e);
                    }
                }
                if (dstPayloadClass != srcPayload.getClass()) {
                    if (trace) {
                        log.trace((Object)("Need to convert event payload from class " + srcPayloadClassName + " to " + dstPayloadClass.getName()));
                    }
                    try {
                        dstPayload = IOTools.clone((Serializable)srcPayload, (ClassLoader)applicationClassLoader);
                    }
                    catch (ClassNotFoundException e) {
                        return new ErrorResponse("Could not convert the event payload from class " + srcPayloadClassName + " to class " + dstPayloadClass.getName(), (Throwable)e);
                    }
                    catch (IOException e) {
                        return new ErrorResponse("Could not convert the event payload from class " + srcPayloadClassName + " to class " + dstPayloadClass.getName(), (Throwable)e);
                    }
                } else {
                    dstPayload = srcPayload;
                }
            }
            eventInvocation.setPayload(dstPayload);
            try {
                PortletInvocationResponse portletInvocationResponse = super.invoke(invocation);
                return portletInvocationResponse;
            }
            finally {
                eventInvocation.setPayload(srcPayload);
            }
        }
        return super.invoke(invocation);
    }
}

