/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.regex.Pattern;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.web.filter.ExtensibleFilter;

public class GenericFilter
extends AbstractFilter {
    private Pattern contextPathPattern;

    public void destroy() {
    }

    protected void afterInit(FilterConfig config) throws ServletException {
        ServletContext servletContext = this.getServletContext();
        this.contextPathPattern = Pattern.compile("[/]*" + servletContext.getContextPath() + "[/]*");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ExoContainer container = this.getContainer();
        ExtensibleFilter filter = (ExtensibleFilter)container.getComponentInstanceOfType(ExtensibleFilter.class);
        if (filter == null) {
            chain.doFilter(request, response);
        } else {
            String path = this.contextPathPattern.matcher(((HttpServletRequest)request).getRequestURI()).replaceFirst("/");
            filter.doFilter(request, response, chain, path);
        }
    }
}

