/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.authorization;

import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AuthorizationManager
extends UserACL {
    private SpaceService spaceService;
    private LayoutService layoutService;

    public AuthorizationManager(InitParams params) {
        super(params);
    }

    public boolean hasEditPermission(Identity identity, String ownerType, String ownerId, String expression) {
        if (PortalConfig.GROUP_TEMPLATE.equalsIgnoreCase(ownerType) || PortalConfig.PORTAL_TEMPLATE.equalsIgnoreCase(ownerType)) {
            return this.isAdministrator(identity);
        }
        if (this.isSpaceSite(ownerType, ownerId)) {
            Space space = this.getSpaceService().getSpaceByGroupId(ownerId);
            return space != null && identity != null && this.getSpaceService().canManageSpaceLayout(space, identity.getUserId());
        }
        return super.hasEditPermission(identity, ownerType, ownerId, expression) || this.isSpacesAdministrator(identity, ownerType, ownerId);
    }

    public boolean hasAccessPermission(Identity identity, String ownerType, String ownerId, Stream<String> expressionsStream) {
        if (PortalConfig.GROUP_TEMPLATE.equalsIgnoreCase(ownerType) || PortalConfig.PORTAL_TEMPLATE.equalsIgnoreCase(ownerType)) {
            return this.isAdministrator(identity);
        }
        return super.hasAccessPermission(identity, ownerType, ownerId, expressionsStream) || this.isSpacesAdministrator(identity, ownerType, ownerId);
    }

    private boolean isSpacesAdministrator(Identity identity, String ownerType, String ownerId) {
        if (this.isAdministrator(identity)) {
            return true;
        }
        if (this.isSpaceSite(ownerType, ownerId)) {
            return this.getSpaceService().isSuperManager(this.getSpaceService().getSpaceByGroupId(ownerId), identity.getUserId());
        }
        if (this.isSpacePublicSite(ownerType, ownerId)) {
            Space space = this.getSpaceService().getSpaceById(this.getSpaceIdFromPublicSite(ownerType, ownerId));
            return space != null && identity != null && this.getSpaceService().canManageSpacePublicSite(space, identity.getUserId());
        }
        return false;
    }

    private boolean isSpaceSite(String ownerType, String ownerId) {
        return PortalConfig.GROUP_TYPE.equalsIgnoreCase(ownerType) && StringUtils.startsWith((CharSequence)ownerId, (CharSequence)"/spaces/");
    }

    private String getSpaceIdFromPublicSite(String ownerType, String ownerId) {
        PortalConfig portalConfig = this.getLayoutService().getPortalConfig(ownerType, ownerId);
        return portalConfig.getProperty("SPACE_ID");
    }

    private boolean isSpacePublicSite(String ownerType, String ownerId) {
        PortalConfig portalConfig = this.getLayoutService().getPortalConfig(ownerType, ownerId);
        return portalConfig != null && portalConfig.getProperty("SPACE_ID") != null;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    private LayoutService getLayoutService() {
        if (this.layoutService == null) {
            this.layoutService = (LayoutService)ExoContainerContext.getService(LayoutService.class);
        }
        return this.layoutService;
    }

    @Generated
    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    @Generated
    public void setLayoutService(LayoutService layoutService) {
        this.layoutService = layoutService;
    }
}

