/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.analytics;

import io.meeds.analytics.model.StatisticData;
import io.meeds.pwa.model.UserPushSubscription;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BasePwaStatisticCollector {
    @Autowired
    private IdentityManager identityManager;

    protected StatisticData addSubscriptionDetails(UserPushSubscription subscription, String username) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("PWA");
        statisticData.setUserId(Long.parseLong(this.getIdentityId(username)));
        statisticData.addParameter("pwaDeviceType", (Object)subscription.getDeviceType());
        statisticData.addParameter("pwaSubscriptionId", (Object)subscription.getId());
        statisticData.addParameter("pwaSubscriptionSite", (Object)this.getSubscriptionDomain(subscription.getEndpoint()));
        return statisticData;
    }

    private String getIdentityId(String username) {
        return this.identityManager.getOrCreateUserIdentity(username).getId();
    }

    private String getSubscriptionDomain(String endpoint) {
        return endpoint.substring(0, endpoint.indexOf("/", 15));
    }
}

