/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.cometd.bayeux.Message;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.AbstractTransport;
import org.cometd.common.JSONContext;
import org.cometd.common.JettyJSONContextClient;

public abstract class ClientTransport
extends AbstractTransport {
    public static final String URL_OPTION = "url";
    public static final String MAX_NETWORK_DELAY_OPTION = "maxNetworkDelay";
    public static final String JSON_CONTEXT_OPTION = "jsonContext";
    public static final String SCHEDULER_OPTION = "scheduler";
    public static final String MAX_SEND_BAYEUX_MESSAGE_SIZE_OPTION = "maxSendBayeuxMessageSize";
    public static final String MAX_MESSAGE_SIZE_OPTION = "maxMessageSize";
    private String url;
    private ScheduledExecutorService scheduler;
    private SchedulerSource schedulerSource = SchedulerSource.UNKNOWN;
    private long maxNetworkDelay;
    private JSONContext.Client jsonContext;
    private int maxSendBayeuxMessageSize;

    @Deprecated
    protected ClientTransport(String name, String url, Map<String, Object> options) {
        this(name, url, options, null);
    }

    protected ClientTransport(String name, String url, Map<String, Object> options, ScheduledExecutorService scheduler) {
        super(name, options);
        this.url = url;
        this.scheduler = scheduler;
        if (scheduler != null) {
            this.schedulerSource = SchedulerSource.PROVIDED;
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void init() {
        Object jsonContextOption;
        Object urlOption = this.getOption(URL_OPTION);
        if (this.url == null) {
            this.url = (String)urlOption;
        }
        if ((jsonContextOption = this.getOption(JSON_CONTEXT_OPTION)) == null) {
            this.jsonContext = new JettyJSONContextClient();
        } else if (jsonContextOption instanceof String) {
            try {
                Class<?> jsonContextClass = Thread.currentThread().getContextClassLoader().loadClass((String)jsonContextOption);
                if (!JSONContext.Client.class.isAssignableFrom(jsonContextClass)) {
                    throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + jsonContextOption);
                }
                this.jsonContext = (JSONContext.Client)jsonContextClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + jsonContextOption, x);
            }
        } else if (jsonContextOption instanceof JSONContext.Client) {
            this.jsonContext = (JSONContext.Client)jsonContextOption;
        } else {
            throw new IllegalArgumentException("Invalid implementation of " + JSONContext.Client.class.getName() + " provided: " + jsonContextOption);
        }
        this.setOption(JSON_CONTEXT_OPTION, this.jsonContext);
        this.maxSendBayeuxMessageSize = this.getOption(MAX_SEND_BAYEUX_MESSAGE_SIZE_OPTION, 0x100000);
    }

    protected JSONContext.Client getJSONContextClient() {
        return this.jsonContext;
    }

    protected void initScheduler() {
        if (this.scheduler == null) {
            this.scheduler = (ScheduledExecutorService)this.getOption(SCHEDULER_OPTION);
            this.schedulerSource = SchedulerSource.SHARED;
            if (this.scheduler == null) {
                this.scheduler = new BayeuxClient.Scheduler(1);
                this.schedulerSource = SchedulerSource.INTERNAL;
            }
        }
    }

    protected void shutdownScheduler() {
        if (this.schedulerSource == SchedulerSource.INTERNAL) {
            this.scheduler.shutdown();
        }
        if (this.schedulerSource != SchedulerSource.PROVIDED) {
            this.scheduler = null;
            this.schedulerSource = SchedulerSource.UNKNOWN;
        }
    }

    protected ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public abstract void abort(Throwable var1);

    public void terminate() {
    }

    public abstract boolean accept(String var1);

    public abstract void send(TransportListener var1, List<Message.Mutable> var2);

    protected List<Message.Mutable> parseMessages(String content) throws ParseException {
        return new ArrayList<Message.Mutable>(List.of(this.jsonContext.parse(content)));
    }

    protected String generateJSON(List<Message.Mutable> messages) {
        return messages.stream().map(message -> this.jsonContext.generate(message)).peek(json -> {
            if (json.length() > this.maxSendBayeuxMessageSize) {
                throw new IllegalArgumentException("Max send Bayeux message size " + this.maxSendBayeuxMessageSize + " exceeded");
            }
        }).collect(Collectors.joining(",", "[", "]"));
    }

    public long getMaxNetworkDelay() {
        this.maxNetworkDelay = this.getOption(MAX_NETWORK_DELAY_OPTION, this.maxNetworkDelay);
        return this.maxNetworkDelay;
    }

    protected void setMaxNetworkDelay(long maxNetworkDelay) {
        this.maxNetworkDelay = maxNetworkDelay;
    }

    private static enum SchedulerSource {
        UNKNOWN,
        PROVIDED,
        SHARED,
        INTERNAL;

    }

    public static interface FailureHandler {
        public void handle(FailureInfo var1);
    }

    public static class FailureInfo {
        public ClientTransport transport;
        public Throwable cause;
        public String error;
        public String action;
        public String url;
        public long delay;

        public BayeuxClient.State actionToState() {
            switch (this.action) {
                case "handshake": {
                    return BayeuxClient.State.REHANDSHAKING;
                }
                case "none": {
                    return BayeuxClient.State.TERMINATING;
                }
            }
            return BayeuxClient.State.UNCONNECTED;
        }

        public String toString() {
            return String.format("%s@%x[transport=%s,cause=%s,action=%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.transport, this.cause, this.action});
        }
    }

    public static interface Factory {
        public ClientTransport newClientTransport(String var1, Map<String, Object> var2);
    }
}

