/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import nl.martijndwars.webpush.Base64Encoder;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class Utils {
    public static final String CURVE = "prime256v1";
    public static final String ALGORITHM = "ECDH";

    public static byte[] encode(ECPublicKey publicKey) {
        return publicKey.getQ().getEncoded(false);
    }

    public static byte[] encode(ECPrivateKey privateKey) {
        return privateKey.getD().toByteArray();
    }

    public static PublicKey loadPublicKey(String encodedPublicKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] decodedPublicKey = Base64Encoder.decode(encodedPublicKey);
        return Utils.loadPublicKey(decodedPublicKey);
    }

    public static PublicKey loadPublicKey(byte[] decodedPublicKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)CURVE);
        ECCurve curve = parameterSpec.getCurve();
        ECPoint point = curve.decodePoint(decodedPublicKey);
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)parameterSpec);
        return keyFactory.generatePublic((KeySpec)pubSpec);
    }

    public static PrivateKey loadPrivateKey(String encodedPrivateKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] decodedPrivateKey = Base64Encoder.decode(encodedPrivateKey);
        return Utils.loadPrivateKey(decodedPrivateKey);
    }

    public static PrivateKey loadPrivateKey(byte[] decodedPrivateKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger s = BigIntegers.fromUnsignedByteArray((byte[])decodedPrivateKey);
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)CURVE);
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(s, (ECParameterSpec)parameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
        return keyFactory.generatePrivate((KeySpec)privateKeySpec);
    }

    public static ECPublicKey loadPublicKey(ECPrivateKey privateKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)CURVE);
        ECPoint Q = ecSpec.getG().multiply(privateKey.getD());
        byte[] publicDerBytes = Q.getEncoded(false);
        ECPoint point = ecSpec.getCurve().decodePoint(publicDerBytes);
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)ecSpec);
        return (ECPublicKey)keyFactory.generatePublic((KeySpec)pubSpec);
    }

    public static boolean verifyKeyPair(PrivateKey privateKey, PublicKey publicKey) {
        ECNamedCurveParameterSpec curveParameters = ECNamedCurveTable.getParameterSpec((String)CURVE);
        ECPoint g = curveParameters.getG();
        ECPoint sG = g.multiply(((java.security.interfaces.ECPrivateKey)privateKey).getS());
        return sG.equals(((ECPublicKey)publicKey).getQ());
    }

    public static byte[] concat(byte[] ... arrays) {
        int lastPos = 0;
        byte[] combined = new byte[Utils.combinedLength(arrays)];
        for (byte[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, combined, lastPos, array.length);
            lastPos += array.length;
        }
        return combined;
    }

    public static int combinedLength(byte[] ... arrays) {
        int combinedLength = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            combinedLength += array.length;
        }
        return combinedLength;
    }

    public static byte[] toByteArray(int integer, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putInt(integer);
        return buffer.array();
    }
}

