/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.PathAddressIterator;
import org.gatein.management.api.annotations.Managed;
import org.gatein.management.api.annotations.ManagedAfter;
import org.gatein.management.api.annotations.ManagedBefore;
import org.gatein.management.api.annotations.ManagedContext;
import org.gatein.management.api.annotations.ManagedRole;
import org.gatein.management.api.model.ModelProvider;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.core.api.AbstractManagedResource;
import org.gatein.management.core.api.model.DmrModelProvider;
import org.gatein.management.core.spi.AnnotatedOperation;

class AnnotatedResource {
    private static final Logger log = LoggerFactory.getLogger((String)"org.gatein.management.core.spi");
    private List<AnnotatedOperation> methods;
    private Object instance;
    private boolean component;
    final Class<?> managedClass;
    final Method beforeMethod;
    final Method afterMethod;
    final AnnotatedResource parent;
    final AnnotatedOperation operation;
    final String managedRole;

    AnnotatedResource(Class<?> managedClass) {
        this(managedClass, null, null);
    }

    AnnotatedResource(Class<?> managedClass, AnnotatedResource parent, AnnotatedOperation operation) {
        this.managedClass = managedClass;
        this.parent = parent;
        this.operation = operation;
        Method[] methods = managedClass.getDeclaredMethods();
        this.beforeMethod = AnnotatedResource.getMethod(methods, ManagedBefore.class);
        this.afterMethod = AnnotatedResource.getMethod(methods, ManagedAfter.class);
        ManagedRole role = managedClass.getAnnotation(ManagedRole.class);
        this.managedRole = role == null ? null : role.value();
    }

    public void register(AbstractManagedResource resource) {
        AbstractManagedResource amr = AnnotatedResource.registerOrGetResource(resource, this.managedClass.getAnnotation(Managed.class));
        for (AnnotatedOperation operation : this.getAnnotatedMethods()) {
            operation.registerOperation(amr);
        }
    }

    Object getInstance(OperationContext context) {
        if (this.instance != null) {
            return this.instance;
        }
        if (this.parent == null) {
            this.instance = context.getRuntimeContext().getRuntimeComponent(this.managedClass);
            if (this.instance != null) {
                this.component = true;
                AnnotatedResource.setModelProvider(this.managedClass, this.instance);
            }
        } else if (this.operation != null) {
            this.instance = this.operation.invokeOperation(context);
        }
        if (this.instance == null) {
            try {
                this.instance = this.managedClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create new instance of class " + this.managedClass.getName(), e);
            }
        }
        if (this.instance != null && !this.component) {
            AnnotatedResource.setModelProvider(this.managedClass, this.instance);
        }
        return this.instance;
    }

    void discardInstance() {
        if (!this.component) {
            this.instance = null;
        }
    }

    public List<AnnotatedOperation> getAnnotatedMethods() {
        if (this.methods == null) {
            ArrayList<AnnotatedOperation> methods = new ArrayList<AnnotatedOperation>();
            for (Method method : this.managedClass.getMethods()) {
                if (!method.isAnnotationPresent(Managed.class)) continue;
                methods.add(new AnnotatedOperation(this, method));
            }
            this.methods = methods;
        }
        return this.methods;
    }

    static AbstractManagedResource registerOrGetResource(AbstractManagedResource resource, Managed managed) {
        PathAddress address = PathAddress.pathAddress((String)managed.value());
        PathAddressIterator iterator = address.iterator();
        while (iterator.hasNext()) {
            AbstractManagedResource child;
            String path = (String)iterator.next();
            String description = "";
            if (iterator.hasNext()) {
                description = managed.description();
            }
            if ((child = (AbstractManagedResource)resource.getSubResource(path)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registering managed resource " + path));
                }
                child = (AbstractManagedResource)resource.registerSubResource(path, AnnotatedResource.description(description));
            }
            resource = child;
        }
        return resource;
    }

    static ManagedDescription description(final String description) {
        return new ManagedDescription(){

            public String getDescription() {
                return description;
            }
        };
    }

    private static Method getMethod(Method[] methods, Class<? extends Annotation> annotation) {
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotation)) continue;
            return method;
        }
        return null;
    }

    private static void setModelProvider(Class<?> managedClass, Object instance) {
        Field[] fields;
        if (instance == null) {
            return;
        }
        for (Field field : fields = managedClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ManagedContext.class)) continue;
            if (field.getType() == ModelProvider.class) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    field.set(instance, DmrModelProvider.INSTANCE);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Unable to set ModelProvider for managed class " + managedClass, e);
                }
            }
            throw new RuntimeException("Field " + field + " is annotated with @ManagedContext, however it has an unknown type " + field.getType() + ". Only ModelProvider is allowed as the type for this field.");
        }
    }
}

