/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationBackgroundStyle;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.ModelData;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class Container
extends ModelObject
implements Cloneable,
IUnmarshallable,
IMarshallable {
    public static final String EVERYONE = "Everyone";
    public static final List<String> DEFAULT_ACCESS_PERMISSIONS = Collections.singletonList("Everyone");
    public static final List<String> DEFAULT_MOVE_APPLICATIONS_PERMISSIONS = Collections.singletonList("Everyone");
    public static final List<String> DEFAULT_MOVE_CONTAINERS_PERMISSIONS = Collections.singletonList("Everyone");
    protected String id;
    protected String name;
    protected String icon;
    protected String template;
    protected String factoryId;
    protected String title;
    protected String description;
    protected String profiles;
    protected String[] accessPermissions;
    protected ArrayList<ModelObject> children;
    protected ApplicationBackgroundStyle appBackgroundStyle;
    public static final String JiBX_bindingList = "|org.exoplatform.portal.config.model.JiBX_bindingFactory|";

    public Container() {
        this.children = new ArrayList();
    }

    public Container(String storageId) {
        super(storageId);
        this.children = new ArrayList();
    }

    public Container(ContainerData data) {
        super(data.getStorageId());
        this.id = data.getId();
        this.name = data.getName();
        this.icon = data.getIcon();
        this.template = data.getTemplate();
        this.factoryId = data.getFactoryId();
        this.title = data.getTitle();
        this.description = data.getDescription();
        this.width = data.getWidth();
        this.height = data.getHeight();
        this.cssClass = data.getCssClass();
        this.cssStyle = data.getCssStyle();
        this.appBackgroundStyle = data.getAppBackgroundStyle();
        this.profiles = data.getProfiles();
        this.accessPermissions = data.getAccessPermissions().toArray(new String[data.getAccessPermissions().size()]);
        this.children = new ArrayList();
        for (ComponentData child : data.getChildren()) {
            ModelObject m = ModelObject.build(child);
            if (m == null) continue;
            this.children.add(ModelObject.build(child));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public ArrayList<ModelObject> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<ModelObject> children) {
        this.children = children;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public void setFactoryId(String factoryId) {
        this.factoryId = factoryId;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    public void setAccessPermissions(String[] accessPermissions) {
        this.accessPermissions = accessPermissions;
    }

    public String getProfiles() {
        return this.profiles;
    }

    public void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    @Override
    public ContainerData build() {
        return new ContainerData(this.getStorageId(), this.getId(), this.getName(), this.getIcon(), this.getTemplate(), this.getFactoryId(), this.getTitle(), this.getDescription(), this.getWidth(), this.getHeight(), this.getCssClass(), this.getProfiles(), this.getCssStyle(), this.getAppBackgroundStyle(), Utils.safeImmutableList(this.accessPermissions), this.buildChildren());
    }

    @Override
    public void checkStorage() throws ObjectNotFoundException {
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            for (ModelObject child : this.getChildren()) {
                child.checkStorage();
            }
        }
    }

    @Override
    public void resetStorage() throws ObjectNotFoundException {
        super.resetStorage();
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            for (ModelObject child : this.getChildren()) {
                child.resetStorage();
            }
        }
    }

    public Container clone() {
        return new Container(this.build());
    }

    protected List<ComponentData> buildChildren() {
        if (StringUtils.isNotBlank((CharSequence)this.getProfiles())) {
            Set activeProfiles = Tools.parseCommaList((String)this.getProfiles());
            if (ExoContainer.getProfiles().stream().noneMatch(activeProfiles::contains)) {
                return Collections.emptyList();
            }
        }
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            ArrayList<ComponentData> dataChildren = new ArrayList<ComponentData>();
            for (int i = 0; i < this.children.size(); ++i) {
                Application application;
                String nodeProfiles;
                ModelObject node = this.children.get(i);
                if (node instanceof Container) {
                    Container container = (Container)node;
                    nodeProfiles = container.getProfiles();
                    if (StringUtils.isNotBlank((CharSequence)nodeProfiles)) {
                        activeProfiles = Tools.parseCommaList((String)nodeProfiles);
                        if (ExoContainer.getProfiles().stream().noneMatch(activeProfiles::contains)) {
                            continue;
                        }
                    }
                } else if (node instanceof Application && StringUtils.isNotBlank((CharSequence)(nodeProfiles = (application = (Application)node).getProfiles()))) {
                    activeProfiles = Tools.parseCommaList((String)nodeProfiles);
                    if (ExoContainer.getProfiles().stream().noneMatch(activeProfiles::contains)) continue;
                }
                ModelData data = node.build();
                ComponentData componentData = (ComponentData)data;
                dataChildren.add(componentData);
            }
            return Collections.unmodifiableList(dataChildren);
        }
        return Collections.emptyList();
    }

    @Generated
    public Container(String id, String name, String icon, String template, String factoryId, String title, String description, String profiles, String[] accessPermissions, ArrayList<ModelObject> children, ApplicationBackgroundStyle appBackgroundStyle) {
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.template = template;
        this.factoryId = factoryId;
        this.title = title;
        this.description = description;
        this.profiles = profiles;
        this.accessPermissions = accessPermissions;
        this.children = children;
        this.appBackgroundStyle = appBackgroundStyle;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container other = (Container)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$factoryId = this.getFactoryId();
        String other$factoryId = other.getFactoryId();
        if (this$factoryId == null ? other$factoryId != null : !this$factoryId.equals(other$factoryId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$profiles = this.getProfiles();
        String other$profiles = other.getProfiles();
        if (this$profiles == null ? other$profiles != null : !this$profiles.equals(other$profiles)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAccessPermissions(), other.getAccessPermissions())) {
            return false;
        }
        ArrayList<ModelObject> this$children = this.getChildren();
        ArrayList<ModelObject> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        ApplicationBackgroundStyle this$appBackgroundStyle = this.getAppBackgroundStyle();
        ApplicationBackgroundStyle other$appBackgroundStyle = other.getAppBackgroundStyle();
        return !(this$appBackgroundStyle == null ? other$appBackgroundStyle != null : !this$appBackgroundStyle.equals(other$appBackgroundStyle));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Container;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $factoryId = this.getFactoryId();
        result = result * 59 + ($factoryId == null ? 43 : $factoryId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $profiles = this.getProfiles();
        result = result * 59 + ($profiles == null ? 43 : $profiles.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAccessPermissions());
        ArrayList<ModelObject> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        ApplicationBackgroundStyle $appBackgroundStyle = this.getAppBackgroundStyle();
        result = result * 59 + ($appBackgroundStyle == null ? 43 : $appBackgroundStyle.hashCode());
        return result;
    }

    @Generated
    public ApplicationBackgroundStyle getAppBackgroundStyle() {
        return this.appBackgroundStyle;
    }

    @Generated
    public void setAppBackgroundStyle(ApplicationBackgroundStyle appBackgroundStyle) {
        this.appBackgroundStyle = appBackgroundStyle;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.portal.config.model.Container").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.portal.config.model.Container";
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.portal.config.model.Container").marshal((Object)this, arg1);
    }
}

