/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.notes.listener.analytics;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.social.cms.service.CMSService;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.listener.PageWikiListener;

public class NotesPageListener
extends PageWikiListener {
    private static final Log LOG = ExoLogger.getLogger(NotesPageListener.class);
    private static final String WIKI_ADD_PAGE_OPERATION = "createContent";
    private static final String WIKI_UPDATE_PAGE_OPERATION = "updateContent";
    private static final String WIKI_DELETE_PAGE_OPERATION = "deleteContent";
    private static final String NOTE_VIEW_CONTENT_OPERATION = "viewContent";
    protected PortalContainer container = PortalContainer.getInstance();
    protected IdentityManager identityManager;
    protected SpaceService spaceService;
    protected CMSService cmsService;
    protected NoteService noteService;

    @Override
    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        this.computeWikiPageStatistics(page, wikiType, wikiOwner, WIKI_ADD_PAGE_OPERATION);
    }

    @Override
    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        if (!(page instanceof DraftPage) && wikiUpdateType != null) {
            this.computeWikiPageStatistics(page, wikiType, wikiOwner, WIKI_UPDATE_PAGE_OPERATION);
        }
    }

    @Override
    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        this.computeWikiPageStatistics(page, wikiType, wikiOwner, WIKI_DELETE_PAGE_OPERATION);
    }

    @Override
    public void markNoteAsViewed(Page note, String viewer) {
        if (!(note instanceof DraftPage)) {
            this.computeWikiPageStatisticsAsync(note, note.getWikiType(), note.getWikiOwner(), viewer, NOTE_VIEW_CONTENT_OPERATION);
        }
    }

    @Override
    public void postDeletePageVersion(PageVersion pageVersion) {
        this.computeWikiPageStatistics(pageVersion, pageVersion.getWikiType(), pageVersion.getWikiOwner(), WIKI_DELETE_PAGE_OPERATION);
    }

    @Override
    public void postUpdatePageVersion(String pageVersionId) {
        this.processPageVersionUpdate(pageVersionId, WIKI_UPDATE_PAGE_OPERATION);
    }

    private void computeWikiPageStatistics(Page page, String wikiType, String wikiOwner, String operation) {
        ConversationState conversationstate = ConversationState.getCurrent();
        String modifierUsername = conversationstate == null || conversationstate.getIdentity() == null ? null : conversationstate.getIdentity().getUserId();
        this.computeWikiPageStatisticsAsync(page, wikiType, wikiOwner, modifierUsername, operation);
    }

    private void computeWikiPageStatisticsAsync(Page page, String wikiType, String wikiOwner, String modifierUsername, String operation) {
        CompletableFuture.supplyAsync(() -> {
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RequestLifeCycle.begin((ExoContainer)this.container);
            try {
                this.createWikiPageStatistic(page, wikiType, wikiOwner, modifierUsername, operation);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error computing wiki statistics", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
            return null;
        });
    }

    private void createWikiPageStatistic(Page page, String wikiType, String wikiOwner, String modifierUsername, String operation) {
        if (page != null && this.getCmsService().getSetting("notePage", page.getName()) == null) {
            long userIdentityId = this.getUserIdentityId(modifierUsername);
            StatisticData statisticData = new StatisticData();
            statisticData.setModule("contents");
            statisticData.setSubModule("contents");
            statisticData.setOperation(operation);
            statisticData.setUserId(userIdentityId);
            String contentId = page.getId();
            if (page instanceof PageVersion) {
                contentId = page.getParent().getId();
            }
            statisticData.addParameter("contentId", (Object)contentId);
            statisticData.addParameter("contentTitle", (Object)page.getTitle());
            if (!operation.equals(WIKI_ADD_PAGE_OPERATION)) {
                statisticData.addParameter("contentLanguage", (Object)(page.getLang() != null ? page.getLang() : "originalVersion"));
            }
            statisticData.addParameter("contentCreator", (Object)page.getAuthor());
            String lastModifier = page.getLastUpdater();
            if (lastModifier == null) {
                PageVersion pageVersion = this.getNoteService().getPublishedVersionByPageIdAndLang(Long.valueOf(page.getId()), page.getLang());
                lastModifier = Objects.requireNonNullElse(pageVersion, page).getAuthor();
            }
            statisticData.addParameter("contentLastModifier", (Object)lastModifier);
            statisticData.addParameter("contentType", (Object)"Note");
            statisticData.addParameter("contentUpdatedDate", (Object)page.getUpdatedDate());
            statisticData.addParameter("contentCreationDate", (Object)page.getCreatedDate());
            if (StringUtils.isNotBlank((CharSequence)wikiOwner) && StringUtils.equalsIgnoreCase((CharSequence)WikiType.GROUP.name(), (CharSequence)wikiType)) {
                Space space = this.getSpaceService().getSpaceByGroupId(wikiOwner);
                AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
            }
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
    }

    private long getUserIdentityId(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return 0L;
        }
        Identity userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", username);
        if (userIdentity == null) {
            return 0L;
        }
        return Long.parseLong(userIdentity.getId());
    }

    private void processPageVersionUpdate(String pageVersionId, String operation) {
        if (pageVersionId == null || pageVersionId.isEmpty()) {
            return;
        }
        String[] data = pageVersionId.split("-");
        Long versionId = Long.parseLong(data[0]);
        String lang = data.length > 1 ? data[1] : null;
        PageVersion pageVersion = this.getNoteService().getPublishedVersionByPageIdAndLang(versionId, lang);
        if (pageVersion != null) {
            this.computeWikiPageStatistics(pageVersion, pageVersion.getWikiType(), pageVersion.getWikiOwner(), operation);
        }
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)this.container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    private CMSService getCmsService() {
        if (this.cmsService == null) {
            this.cmsService = (CMSService)this.container.getComponentInstanceOfType(CMSService.class);
        }
        return this.cmsService;
    }

    private NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = (NoteService)this.container.getComponentInstanceOfType(NoteService.class);
        }
        return this.noteService;
    }
}

