/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.web.login.LoginUtils;
import org.exoplatform.web.security.security.CookieTokenService;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.security.Credentials;

public class RememberMeFilter
extends AbstractFilter {
    private List<String> ignoredPaths = null;

    protected void afterInit(FilterConfig config) throws ServletException {
        String ignoredPathsParameter = config.getInitParameter("ignoredPaths");
        this.ignoredPaths = StringUtils.isBlank((CharSequence)ignoredPathsParameter) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)ignoredPathsParameter, (String)","));
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)req, (HttpServletResponse)resp, chain);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        block3: {
            ExoContainer container;
            CookieTokenService tokenservice;
            String username;
            String token;
            ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
            String servletPath = request.getServletPath();
            if (request.getRemoteUser() == null && this.ignoredPaths.stream().noneMatch(ignoredPath -> StringUtils.startsWith((CharSequence)servletPath, (CharSequence)ignoredPath)) && (token = LoginUtils.getRememberMeTokenCookie(request)) != null && (username = (tokenservice = (CookieTokenService)(container = this.getContainer()).getComponentInstanceOfType(CookieTokenService.class)).validateToken(token, false)) != null) {
                Credentials credentials = new Credentials(username, "");
                ServletContainer servletContainer = ServletContainerFactory.getServletContainer();
                try {
                    servletContainer.login(request, response, credentials);
                }
                catch (Exception e) {
                    if (request.getRemoteUser() != null) break block3;
                    Cookie cookie = new Cookie("rememberme", "");
                    cookie.setPath("/");
                    cookie.setMaxAge(0);
                    cookie.setHttpOnly(true);
                    cookie.setSecure(request.isSecure());
                    response.addCookie(cookie);
                }
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void begin(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            ComponentRequestLifecycle componentRequestLifcycle = (ComponentRequestLifecycle)orgService;
            RequestLifeCycle.begin((ComponentRequestLifecycle)componentRequestLifcycle);
        }
    }

    public void end(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

