/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j;

import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.MultiPathFileSource;
import java.io.File;
import java.net.URI;
import java.util.Arrays;

public class MultiPathStringSource
extends LessSource {
    private File[] includePaths;
    private String name;
    private String content;
    private String charsetName;
    private URI uri;

    public MultiPathStringSource(String content, String name, URI uri, String charsetName, File ... includePaths) {
        this.content = content;
        this.name = name;
        this.uri = uri;
        this.charsetName = charsetName;
        this.includePaths = includePaths;
    }

    public MultiPathStringSource(String content, String name, URI uri, File ... includePaths) {
        this.content = content;
        this.name = name;
        this.uri = uri;
        this.includePaths = includePaths;
    }

    public MultiPathStringSource(String content, String name, File ... includePaths) {
        this.content = content;
        this.name = name;
        this.includePaths = includePaths;
    }

    public MultiPathStringSource(String content, File ... includePaths) {
        this.content = content;
        this.charsetName = null;
        this.includePaths = includePaths;
    }

    @Override
    public LessSource relativeSource(String filename) throws LessSource.FileNotFound {
        for (int i = 0; i < this.includePaths.length; ++i) {
            File directory = this.includePaths[i];
            File newFile = new File(directory, filename);
            if (!newFile.exists()) continue;
            return new MultiPathFileSource(newFile, this.charsetName, this.includePaths);
        }
        throw new LessSource.FileNotFound();
    }

    @Override
    public String getContent() throws LessSource.FileNotFound, LessSource.CannotReadFile {
        return this.content;
    }

    @Override
    public byte[] getBytes() throws LessSource.FileNotFound, LessSource.CannotReadFile {
        if (this.content != null) {
            this.content.getBytes();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charsetName == null ? 0 : this.charsetName.hashCode());
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + Arrays.hashCode(this.includePaths);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiPathStringSource other = (MultiPathStringSource)obj;
        if (this.charsetName == null ? other.charsetName != null : !this.charsetName.equals(other.charsetName)) {
            return false;
        }
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (!Arrays.equals(this.includePaths, other.includePaths)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

