/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.CompoundApplicationMessage;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.MultipleConditionsValidator;

@Serialized
public class UsernameValidator
extends MultipleConditionsValidator {
    protected static final int DEFAULT_MIN_LENGTH = 3;
    protected static final int DEFAULT_MAX_LENGTH = 30;
    protected Integer min = 3;
    protected Integer max = 30;
    public static final String ALLOWED_SYMBOLS = "'_', '.'";

    public UsernameValidator() {
    }

    public UsernameValidator(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    @Override
    protected void validate(String value, String label, CompoundApplicationMessage messages, UIFormInput uiInput) {
        UsernameValidator.validate(value, label, messages, this.min, this.max);
    }

    static void validate(String value, String label, CompoundApplicationMessage messages, Integer min, Integer max) {
        char c;
        char[] buff = value.toCharArray();
        if (buff.length < min || buff.length > max) {
            messages.addMessage("StringLengthValidator.msg.length-invalid", new Object[]{label, min.toString(), max.toString()});
        }
        if (!Character.isLowerCase(buff[0])) {
            messages.addMessage("FirstCharacterUsernameValidator.msg", new Object[]{label});
        }
        if (!UsernameValidator.isLowerCaseLetterOrDigit(c = buff[buff.length - 1])) {
            messages.addMessage("LastCharacterUsernameValidator.msg", new Object[]{label, Character.valueOf(c)});
        }
        boolean hasConsecutive = false;
        boolean hasInvalid = false;
        for (int i = 1; i < buff.length - 1; ++i) {
            c = buff[i];
            if (UsernameValidator.isLowerCaseLetterOrDigit(c)) continue;
            if (UsernameValidator.isSymbol(c)) {
                char next = buff[i + 1];
                if (UsernameValidator.isSymbol(next)) {
                    if (!hasConsecutive) {
                        messages.addMessage("ConsecutiveSymbolValidator.msg", new Object[]{label, ALLOWED_SYMBOLS});
                        hasConsecutive = true;
                    }
                } else if (!Character.isLetterOrDigit(next) && !hasInvalid) {
                    messages.addMessage("UsernameValidator.msg.Invalid-char", new Object[]{label});
                    hasInvalid = true;
                }
            } else if (!hasInvalid) {
                messages.addMessage("UsernameValidator.msg.Invalid-char", new Object[]{label});
                hasInvalid = true;
            }
            if (hasConsecutive && hasInvalid) break;
        }
    }

    private static boolean isLowerCaseLetterOrDigit(char character) {
        return Character.isDigit(character) || character >= 'a' && character <= 'z';
    }

    private static boolean isSymbol(char c) {
        return c == '_' || c == '.';
    }
}

