/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.navigation.plugin.AbstractLayoutSidebarPlugin;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=10)
public class SiteSidebarPlugin
extends AbstractLayoutSidebarPlugin {
    @Autowired
    private UserPortalConfigService userPortalConfigService;

    public SidebarItemType getType() {
        return SidebarItemType.SITE;
    }

    public boolean itemExists(SidebarItem item, String username) {
        if (item == null || item.getProperties() == null) {
            return false;
        }
        PortalConfig site = this.layoutService.getPortalConfig(this.getSiteKey(item));
        return site != null && this.userAcl.hasAccessPermission(site, this.userAcl.getUserIdentity(username));
    }

    public SidebarItem resolveProperties(SidebarItem item, String username, Locale locale) {
        NodeContext rootNode;
        SiteKey siteKey = this.getSiteKey(item);
        item.setName(this.getSiteLabel(siteKey, locale));
        if (StringUtils.isBlank((CharSequence)item.getIcon())) {
            item.setIcon(this.getSiteIcon(siteKey));
        }
        if (StringUtils.isBlank((CharSequence)item.getUrl())) {
            item.setUrl("/portal/" + siteKey.getName());
        }
        if (StringUtils.equals((CharSequence)((CharSequence)item.getProperties().get("expandPages")), (CharSequence)"true") && (rootNode = this.navigationService.loadNode(siteKey)) != null && rootNode.getSize() > 0) {
            item.setItems(rootNode.getNodes().stream().filter(n -> this.isEligiblePage(Long.parseLong(n.getId()), username)).map(node -> {
                SidebarItem pageItem = new SidebarItem(SidebarItemType.PAGE);
                pageItem.setProperties(Collections.singletonMap("navigationNodeId", node.getData().getId()));
                return this.resolvePageItemProperties(pageItem, locale);
            }).toList());
        }
        item.setDefaultPath(true);
        return item;
    }

    public List<SidebarItem> getDefaultItems() {
        SiteFilter siteFilter = new SiteFilter();
        siteFilter.setDisplayed(true);
        siteFilter.setSiteType(SiteType.PORTAL);
        siteFilter.setExcludedSiteName("global");
        siteFilter.setExcludeSpaceSites(true);
        siteFilter.setSortByDisplayOrder(true);
        siteFilter.setFilterByDisplayed(true);
        List sites = this.layoutService.getSites(siteFilter);
        return sites.stream().map(site -> this.toSidebarItem(SiteKey.portal((String)site.getName()))).toList();
    }

    protected SidebarItem toSidebarItem(SiteKey siteKey) {
        return new SidebarItem(siteKey.getName(), "/portal/" + siteKey.getName(), null, null, this.getSiteIcon(siteKey), SidebarItemType.SITE, null, this.buildSiteProperties(siteKey), true);
    }

    private Map<String, String> buildSiteProperties(SiteKey siteKey) {
        PortalConfig site = this.layoutService.getPortalConfig(siteKey);
        long siteId = Long.parseLong(site.getStorageId().split("_")[1]);
        boolean isMetaSite = StringUtils.equals((CharSequence)this.userPortalConfigService.getMetaPortal(), (CharSequence)siteKey.getName());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("siteType", siteKey.getTypeName());
        properties.put("siteName", siteKey.getName());
        properties.put("siteId", String.valueOf(siteId));
        if (isMetaSite) {
            properties.put("expandPages", "true");
        }
        return properties;
    }

    private SiteKey getSiteKey(SidebarItem item) {
        return new SiteKey((String)item.getProperties().get("siteType"), (String)item.getProperties().get("siteName"));
    }
}

