/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import jakarta.persistence.GenerationType;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import java.util.UUID;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.id.IncrementGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class GenerationStrategyInterpreter {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(GenerationStrategyInterpreter.class);
    public static final GenerationStrategyInterpreter STRATEGY_INTERPRETER = new GenerationStrategyInterpreter();

    private GenerationStrategyInterpreter() {
    }

    public String determineGeneratorName(GenerationType generationType, GeneratorNameDeterminationContext context) {
        switch (generationType) {
            case IDENTITY: {
                return "identity";
            }
            case SEQUENCE: {
                return SequenceStyleGenerator.class.getName();
            }
            case TABLE: {
                return org.hibernate.id.enhanced.TableGenerator.class.getName();
            }
            case UUID: {
                return UUIDGenerator.class.getName();
            }
            case AUTO: {
                if (UUID.class.isAssignableFrom(context.getIdType())) {
                    return UUIDGenerator.class.getName();
                }
                if ("increment".equalsIgnoreCase(context.getGeneratedValueGeneratorName())) {
                    return IncrementGenerator.class.getName();
                }
                return SequenceStyleGenerator.class.getName();
            }
        }
        throw new UnsupportedOperationException("Unsupported generation type:" + String.valueOf(generationType));
    }

    public void interpretTableGenerator(TableGenerator tableGeneratorAnnotation, IdentifierGeneratorDefinition.Builder definitionBuilder) {
        definitionBuilder.setName(tableGeneratorAnnotation.name());
        definitionBuilder.setStrategy(org.hibernate.id.enhanced.TableGenerator.class.getName());
        definitionBuilder.addParam("prefer_entity_table_as_segment_value", "true");
        if (!tableGeneratorAnnotation.catalog().isEmpty()) {
            definitionBuilder.addParam("catalog", tableGeneratorAnnotation.catalog());
        }
        if (!tableGeneratorAnnotation.schema().isEmpty()) {
            definitionBuilder.addParam("schema", tableGeneratorAnnotation.schema());
        }
        if (!tableGeneratorAnnotation.table().isEmpty()) {
            definitionBuilder.addParam("table_name", tableGeneratorAnnotation.table());
        }
        if (!tableGeneratorAnnotation.pkColumnName().isEmpty()) {
            definitionBuilder.addParam("segment_column_name", tableGeneratorAnnotation.pkColumnName());
        }
        if (!tableGeneratorAnnotation.pkColumnValue().isEmpty()) {
            definitionBuilder.addParam("segment_value", tableGeneratorAnnotation.pkColumnValue());
        }
        if (!tableGeneratorAnnotation.valueColumnName().isEmpty()) {
            definitionBuilder.addParam("value_column_name", tableGeneratorAnnotation.valueColumnName());
        }
        definitionBuilder.addParam("increment_size", String.valueOf(tableGeneratorAnnotation.allocationSize()));
        definitionBuilder.addParam("initial_value", String.valueOf(tableGeneratorAnnotation.initialValue() + 1));
        if (tableGeneratorAnnotation.uniqueConstraints() != null && tableGeneratorAnnotation.uniqueConstraints().length > 0) {
            LOG.ignoringTableGeneratorConstraints(tableGeneratorAnnotation.name());
        }
    }

    public void interpretSequenceGenerator(SequenceGenerator sequenceGeneratorAnnotation, IdentifierGeneratorDefinition.Builder definitionBuilder) {
        definitionBuilder.setName(sequenceGeneratorAnnotation.name());
        definitionBuilder.setStrategy(SequenceStyleGenerator.class.getName());
        if (!sequenceGeneratorAnnotation.catalog().isEmpty()) {
            definitionBuilder.addParam("catalog", sequenceGeneratorAnnotation.catalog());
        }
        if (!sequenceGeneratorAnnotation.schema().isEmpty()) {
            definitionBuilder.addParam("schema", sequenceGeneratorAnnotation.schema());
        }
        if (!sequenceGeneratorAnnotation.sequenceName().isEmpty()) {
            definitionBuilder.addParam("sequence_name", sequenceGeneratorAnnotation.sequenceName());
        }
        definitionBuilder.addParam("increment_size", String.valueOf(sequenceGeneratorAnnotation.allocationSize()));
        definitionBuilder.addParam("initial_value", String.valueOf(sequenceGeneratorAnnotation.initialValue()));
    }

    public static interface GeneratorNameDeterminationContext {
        public Class<?> getIdType();

        public String getGeneratedValueGeneratorName();
    }
}

