/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigUpdate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigUpdateVariant;
import co.elastic.clients.elasticsearch.ml.NlpTokenizationUpdateOptions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FillMaskInferenceUpdateOptions
implements InferenceConfigUpdateVariant,
JsonpSerializable {
    @Nullable
    private final Integer numTopClasses;
    @Nullable
    private final NlpTokenizationUpdateOptions tokenization;
    @Nullable
    private final String resultsField;
    public static final JsonpDeserializer<FillMaskInferenceUpdateOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FillMaskInferenceUpdateOptions::setupFillMaskInferenceUpdateOptionsDeserializer);

    private FillMaskInferenceUpdateOptions(Builder builder) {
        this.numTopClasses = builder.numTopClasses;
        this.tokenization = builder.tokenization;
        this.resultsField = builder.resultsField;
    }

    public static FillMaskInferenceUpdateOptions of(Function<Builder, ObjectBuilder<FillMaskInferenceUpdateOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfigUpdate.Kind _inferenceConfigUpdateKind() {
        return InferenceConfigUpdate.Kind.FillMask;
    }

    @Nullable
    public final Integer numTopClasses() {
        return this.numTopClasses;
    }

    @Nullable
    public final NlpTokenizationUpdateOptions tokenization() {
        return this.tokenization;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numTopClasses != null) {
            generator.writeKey("num_top_classes");
            generator.write(this.numTopClasses.intValue());
        }
        if (this.tokenization != null) {
            generator.writeKey("tokenization");
            this.tokenization.serialize(generator, mapper);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFillMaskInferenceUpdateOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numTopClasses, JsonpDeserializer.integerDeserializer(), "num_top_classes");
        op.add(Builder::tokenization, NlpTokenizationUpdateOptions._DESERIALIZER, "tokenization");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FillMaskInferenceUpdateOptions> {
        @Nullable
        private Integer numTopClasses;
        @Nullable
        private NlpTokenizationUpdateOptions tokenization;
        @Nullable
        private String resultsField;

        public final Builder numTopClasses(@Nullable Integer value) {
            this.numTopClasses = value;
            return this;
        }

        public final Builder tokenization(@Nullable NlpTokenizationUpdateOptions value) {
            this.tokenization = value;
            return this;
        }

        public final Builder tokenization(Function<NlpTokenizationUpdateOptions.Builder, ObjectBuilder<NlpTokenizationUpdateOptions>> fn) {
            return this.tokenization(fn.apply(new NlpTokenizationUpdateOptions.Builder()).build());
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FillMaskInferenceUpdateOptions build() {
            this._checkSingleUse();
            return new FillMaskInferenceUpdateOptions(this);
        }
    }
}

