/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.filter;

import io.meeds.oauth.filter.OAuthAbstractFilter;
import io.meeds.oauth.service.OAuthRegistrationService;
import io.meeds.oauth.spi.OAuthPrincipal;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.security.AuthenticationRegistry;

public class OauthSignupOnflyFilter
extends OAuthAbstractFilter {
    static final String SESSION_KEY_SIGNUP_ON_FLY_ERROR = "__onfly_error";

    @Override
    protected void executeFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        AuthenticationRegistry authenticationRegistry = this.getService(AuthenticationRegistry.class);
        OAuthRegistrationService oAuthRegistrationService = this.getService(OAuthRegistrationService.class);
        if (oAuthRegistrationService == null || this.userExists(request, authenticationRegistry)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        OAuthPrincipal<?> principal = this.getPrincipal(request, authenticationRegistry);
        if (oAuthRegistrationService.isRegistrationOnFly(principal.getOauthProviderType())) {
            User user;
            String oauth = principal.getOauthProviderType().getKey() + "_" + principal.getUserName();
            String onFlyError = (String)request.getSession().getAttribute(SESSION_KEY_SIGNUP_ON_FLY_ERROR);
            if (StringUtils.isNotBlank((CharSequence)onFlyError)) {
                if (StringUtils.equals((CharSequence)oauth, (CharSequence)onFlyError)) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                request.getSession().removeAttribute(SESSION_KEY_SIGNUP_ON_FLY_ERROR);
            }
            if ((user = oAuthRegistrationService.detectGateInUser(request, principal)) != null) {
                oAuthRegistrationService.updateCustomClaimsInProfile(user, principal);
                authenticationRegistry.setAttributeOfClient(request, "_authenticatedPortalUserDetected", (Object)user);
            } else {
                User registeredUser = oAuthRegistrationService.createGateInUser(principal);
                if (registeredUser != null) {
                    authenticationRegistry.removeAttributeOfClient(request, "_authenticatedPortalUser");
                    response.sendRedirect(this.getContext().getContextPath());
                    return;
                }
                request.getSession().setAttribute(SESSION_KEY_SIGNUP_ON_FLY_ERROR, (Object)oauth);
                request.getSession().setAttribute("oauth_onfly_error", (Object)Boolean.TRUE);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private OAuthPrincipal<?> getPrincipal(HttpServletRequest request, AuthenticationRegistry authenticationRegistry) {
        OAuthPrincipal principal = (OAuthPrincipal)authenticationRegistry.getAttributeOfClient(request, "_authenticatedOAuthPrincipal");
        return principal;
    }

    private boolean userExists(HttpServletRequest request, AuthenticationRegistry authenticationRegistry) {
        User detectedUser = (User)authenticationRegistry.getAttributeOfClient(request, "_authenticatedPortalUserDetected");
        return detectedUser != null;
    }
}

