/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigCreate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigCreateVariant;
import co.elastic.clients.elasticsearch.ml.ModelPackageConfig;
import co.elastic.clients.elasticsearch.ml.TrainedModelConfigInput;
import co.elastic.clients.elasticsearch.ml.TrainedModelConfigMetadata;
import co.elastic.clients.elasticsearch.ml.TrainedModelLocation;
import co.elastic.clients.elasticsearch.ml.TrainedModelPrefixStrings;
import co.elastic.clients.elasticsearch.ml.TrainedModelType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelConfig
implements JsonpSerializable {
    private final String modelId;
    @Nullable
    private final TrainedModelType modelType;
    private final List<String> tags;
    @Nullable
    private final String version;
    @Nullable
    private final String compressedDefinition;
    @Nullable
    private final String createdBy;
    @Nullable
    private final DateTime createTime;
    private final Map<String, String> defaultFieldMap;
    @Nullable
    private final String description;
    @Nullable
    private final Integer estimatedHeapMemoryUsageBytes;
    @Nullable
    private final Integer estimatedOperations;
    @Nullable
    private final Boolean fullyDefined;
    @Nullable
    private final InferenceConfigCreate inferenceConfig;
    private final TrainedModelConfigInput input;
    @Nullable
    private final String licenseLevel;
    @Nullable
    private final TrainedModelConfigMetadata metadata;
    @Nullable
    private final String modelSizeBytes;
    @Nullable
    private final ModelPackageConfig modelPackage;
    @Nullable
    private final TrainedModelLocation location;
    @Nullable
    private final String platformArchitecture;
    @Nullable
    private final TrainedModelPrefixStrings prefixStrings;
    public static final JsonpDeserializer<TrainedModelConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelConfig::setupTrainedModelConfigDeserializer);

    protected TrainedModelConfig(AbstractBuilder<?> builder) {
        this.modelId = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).modelId, this, "modelId");
        this.modelType = ((AbstractBuilder)builder).modelType;
        this.tags = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).tags, (Object)this, "tags");
        this.version = ((AbstractBuilder)builder).version;
        this.compressedDefinition = ((AbstractBuilder)builder).compressedDefinition;
        this.createdBy = ((AbstractBuilder)builder).createdBy;
        this.createTime = ((AbstractBuilder)builder).createTime;
        this.defaultFieldMap = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).defaultFieldMap);
        this.description = ((AbstractBuilder)builder).description;
        this.estimatedHeapMemoryUsageBytes = ((AbstractBuilder)builder).estimatedHeapMemoryUsageBytes;
        this.estimatedOperations = ((AbstractBuilder)builder).estimatedOperations;
        this.fullyDefined = ((AbstractBuilder)builder).fullyDefined;
        this.inferenceConfig = ((AbstractBuilder)builder).inferenceConfig;
        this.input = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).input, this, "input");
        this.licenseLevel = ((AbstractBuilder)builder).licenseLevel;
        this.metadata = ((AbstractBuilder)builder).metadata;
        this.modelSizeBytes = ((AbstractBuilder)builder).modelSizeBytes;
        this.modelPackage = ((AbstractBuilder)builder).modelPackage;
        this.location = ((AbstractBuilder)builder).location;
        this.platformArchitecture = ((AbstractBuilder)builder).platformArchitecture;
        this.prefixStrings = ((AbstractBuilder)builder).prefixStrings;
    }

    public static TrainedModelConfig trainedModelConfigOf(Function<Builder, ObjectBuilder<TrainedModelConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final TrainedModelType modelType() {
        return this.modelType;
    }

    public final List<String> tags() {
        return this.tags;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Nullable
    public final String compressedDefinition() {
        return this.compressedDefinition;
    }

    @Nullable
    public final String createdBy() {
        return this.createdBy;
    }

    @Nullable
    public final DateTime createTime() {
        return this.createTime;
    }

    public final Map<String, String> defaultFieldMap() {
        return this.defaultFieldMap;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Integer estimatedHeapMemoryUsageBytes() {
        return this.estimatedHeapMemoryUsageBytes;
    }

    @Nullable
    public final Integer estimatedOperations() {
        return this.estimatedOperations;
    }

    @Nullable
    public final Boolean fullyDefined() {
        return this.fullyDefined;
    }

    @Nullable
    public final InferenceConfigCreate inferenceConfig() {
        return this.inferenceConfig;
    }

    public final TrainedModelConfigInput input() {
        return this.input;
    }

    @Nullable
    public final String licenseLevel() {
        return this.licenseLevel;
    }

    @Nullable
    public final TrainedModelConfigMetadata metadata() {
        return this.metadata;
    }

    @Nullable
    public final String modelSizeBytes() {
        return this.modelSizeBytes;
    }

    @Nullable
    public final ModelPackageConfig modelPackage() {
        return this.modelPackage;
    }

    @Nullable
    public final TrainedModelLocation location() {
        return this.location;
    }

    @Nullable
    public final String platformArchitecture() {
        return this.platformArchitecture;
    }

    @Nullable
    public final TrainedModelPrefixStrings prefixStrings() {
        return this.prefixStrings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.modelType != null) {
            generator.writeKey("model_type");
            this.modelType.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.tags)) {
            generator.writeKey("tags");
            generator.writeStartArray();
            for (String string : this.tags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.compressedDefinition != null) {
            generator.writeKey("compressed_definition");
            generator.write(this.compressedDefinition);
        }
        if (this.createdBy != null) {
            generator.writeKey("created_by");
            generator.write(this.createdBy);
        }
        if (this.createTime != null) {
            generator.writeKey("create_time");
            this.createTime.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.defaultFieldMap)) {
            generator.writeKey("default_field_map");
            generator.writeStartObject();
            for (Map.Entry entry : this.defaultFieldMap.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.estimatedHeapMemoryUsageBytes != null) {
            generator.writeKey("estimated_heap_memory_usage_bytes");
            generator.write(this.estimatedHeapMemoryUsageBytes.intValue());
        }
        if (this.estimatedOperations != null) {
            generator.writeKey("estimated_operations");
            generator.write(this.estimatedOperations.intValue());
        }
        if (this.fullyDefined != null) {
            generator.writeKey("fully_defined");
            generator.write(this.fullyDefined.booleanValue());
        }
        if (this.inferenceConfig != null) {
            generator.writeKey("inference_config");
            this.inferenceConfig.serialize(generator, mapper);
        }
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
        if (this.licenseLevel != null) {
            generator.writeKey("license_level");
            generator.write(this.licenseLevel);
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            this.metadata.serialize(generator, mapper);
        }
        if (this.modelSizeBytes != null) {
            generator.writeKey("model_size_bytes");
            generator.write(this.modelSizeBytes);
        }
        if (this.modelPackage != null) {
            generator.writeKey("model_package");
            this.modelPackage.serialize(generator, mapper);
        }
        if (this.location != null) {
            generator.writeKey("location");
            this.location.serialize(generator, mapper);
        }
        if (this.platformArchitecture != null) {
            generator.writeKey("platform_architecture");
            generator.write(this.platformArchitecture);
        }
        if (this.prefixStrings != null) {
            generator.writeKey("prefix_strings");
            this.prefixStrings.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupTrainedModelConfigDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(AbstractBuilder::modelType, TrainedModelType._DESERIALIZER, "model_type");
        op.add(AbstractBuilder::tags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tags");
        op.add(AbstractBuilder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(AbstractBuilder::compressedDefinition, JsonpDeserializer.stringDeserializer(), "compressed_definition");
        op.add(AbstractBuilder::createdBy, JsonpDeserializer.stringDeserializer(), "created_by");
        op.add(AbstractBuilder::createTime, DateTime._DESERIALIZER, "create_time");
        op.add(AbstractBuilder::defaultFieldMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "default_field_map");
        op.add(AbstractBuilder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(AbstractBuilder::estimatedHeapMemoryUsageBytes, JsonpDeserializer.integerDeserializer(), "estimated_heap_memory_usage_bytes");
        op.add(AbstractBuilder::estimatedOperations, JsonpDeserializer.integerDeserializer(), "estimated_operations");
        op.add(AbstractBuilder::fullyDefined, JsonpDeserializer.booleanDeserializer(), "fully_defined");
        op.add(AbstractBuilder::inferenceConfig, InferenceConfigCreate._DESERIALIZER, "inference_config");
        op.add(AbstractBuilder::input, TrainedModelConfigInput._DESERIALIZER, "input");
        op.add(AbstractBuilder::licenseLevel, JsonpDeserializer.stringDeserializer(), "license_level");
        op.add(AbstractBuilder::metadata, TrainedModelConfigMetadata._DESERIALIZER, "metadata");
        op.add(AbstractBuilder::modelSizeBytes, JsonpDeserializer.stringDeserializer(), "model_size_bytes");
        op.add(AbstractBuilder::modelPackage, ModelPackageConfig._DESERIALIZER, "model_package");
        op.add(AbstractBuilder::location, TrainedModelLocation._DESERIALIZER, "location");
        op.add(AbstractBuilder::platformArchitecture, JsonpDeserializer.stringDeserializer(), "platform_architecture");
        op.add(AbstractBuilder::prefixStrings, TrainedModelPrefixStrings._DESERIALIZER, "prefix_strings");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String modelId;
        @Nullable
        private TrainedModelType modelType;
        private List<String> tags;
        @Nullable
        private String version;
        @Nullable
        private String compressedDefinition;
        @Nullable
        private String createdBy;
        @Nullable
        private DateTime createTime;
        @Nullable
        private Map<String, String> defaultFieldMap;
        @Nullable
        private String description;
        @Nullable
        private Integer estimatedHeapMemoryUsageBytes;
        @Nullable
        private Integer estimatedOperations;
        @Nullable
        private Boolean fullyDefined;
        @Nullable
        private InferenceConfigCreate inferenceConfig;
        private TrainedModelConfigInput input;
        @Nullable
        private String licenseLevel;
        @Nullable
        private TrainedModelConfigMetadata metadata;
        @Nullable
        private String modelSizeBytes;
        @Nullable
        private ModelPackageConfig modelPackage;
        @Nullable
        private TrainedModelLocation location;
        @Nullable
        private String platformArchitecture;
        @Nullable
        private TrainedModelPrefixStrings prefixStrings;

        public final BuilderT modelId(String value) {
            this.modelId = value;
            return (BuilderT)this.self();
        }

        public final BuilderT modelType(@Nullable TrainedModelType value) {
            this.modelType = value;
            return (BuilderT)this.self();
        }

        public final BuilderT tags(List<String> list) {
            this.tags = AbstractBuilder._listAddAll(this.tags, list);
            return (BuilderT)this.self();
        }

        public final BuilderT tags(String value, String ... values) {
            this.tags = AbstractBuilder._listAdd(this.tags, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT version(@Nullable String value) {
            this.version = value;
            return (BuilderT)this.self();
        }

        public final BuilderT compressedDefinition(@Nullable String value) {
            this.compressedDefinition = value;
            return (BuilderT)this.self();
        }

        public final BuilderT createdBy(@Nullable String value) {
            this.createdBy = value;
            return (BuilderT)this.self();
        }

        public final BuilderT createTime(@Nullable DateTime value) {
            this.createTime = value;
            return (BuilderT)this.self();
        }

        public final BuilderT defaultFieldMap(Map<String, String> map) {
            this.defaultFieldMap = AbstractBuilder._mapPutAll(this.defaultFieldMap, map);
            return (BuilderT)this.self();
        }

        public final BuilderT defaultFieldMap(String key, String value) {
            this.defaultFieldMap = AbstractBuilder._mapPut(this.defaultFieldMap, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT description(@Nullable String value) {
            this.description = value;
            return (BuilderT)this.self();
        }

        public final BuilderT estimatedHeapMemoryUsageBytes(@Nullable Integer value) {
            this.estimatedHeapMemoryUsageBytes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT estimatedOperations(@Nullable Integer value) {
            this.estimatedOperations = value;
            return (BuilderT)this.self();
        }

        public final BuilderT fullyDefined(@Nullable Boolean value) {
            this.fullyDefined = value;
            return (BuilderT)this.self();
        }

        public final BuilderT inferenceConfig(@Nullable InferenceConfigCreate value) {
            this.inferenceConfig = value;
            return (BuilderT)this.self();
        }

        public final BuilderT inferenceConfig(Function<InferenceConfigCreate.Builder, ObjectBuilder<InferenceConfigCreate>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfigCreate.Builder()).build());
        }

        public final BuilderT inferenceConfig(InferenceConfigCreateVariant value) {
            this.inferenceConfig = value._toInferenceConfigCreate();
            return (BuilderT)this.self();
        }

        public final BuilderT input(TrainedModelConfigInput value) {
            this.input = value;
            return (BuilderT)this.self();
        }

        public final BuilderT input(Function<TrainedModelConfigInput.Builder, ObjectBuilder<TrainedModelConfigInput>> fn) {
            return this.input(fn.apply(new TrainedModelConfigInput.Builder()).build());
        }

        public final BuilderT licenseLevel(@Nullable String value) {
            this.licenseLevel = value;
            return (BuilderT)this.self();
        }

        public final BuilderT metadata(@Nullable TrainedModelConfigMetadata value) {
            this.metadata = value;
            return (BuilderT)this.self();
        }

        public final BuilderT metadata(Function<TrainedModelConfigMetadata.Builder, ObjectBuilder<TrainedModelConfigMetadata>> fn) {
            return this.metadata(fn.apply(new TrainedModelConfigMetadata.Builder()).build());
        }

        public final BuilderT modelSizeBytes(@Nullable String value) {
            this.modelSizeBytes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT modelPackage(@Nullable ModelPackageConfig value) {
            this.modelPackage = value;
            return (BuilderT)this.self();
        }

        public final BuilderT modelPackage(Function<ModelPackageConfig.Builder, ObjectBuilder<ModelPackageConfig>> fn) {
            return this.modelPackage(fn.apply(new ModelPackageConfig.Builder()).build());
        }

        public final BuilderT location(@Nullable TrainedModelLocation value) {
            this.location = value;
            return (BuilderT)this.self();
        }

        public final BuilderT location(Function<TrainedModelLocation.Builder, ObjectBuilder<TrainedModelLocation>> fn) {
            return this.location(fn.apply(new TrainedModelLocation.Builder()).build());
        }

        public final BuilderT platformArchitecture(@Nullable String value) {
            this.platformArchitecture = value;
            return (BuilderT)this.self();
        }

        public final BuilderT prefixStrings(@Nullable TrainedModelPrefixStrings value) {
            this.prefixStrings = value;
            return (BuilderT)this.self();
        }

        public final BuilderT prefixStrings(Function<TrainedModelPrefixStrings.Builder, ObjectBuilder<TrainedModelPrefixStrings>> fn) {
            return this.prefixStrings(fn.apply(new TrainedModelPrefixStrings.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<TrainedModelConfig> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelConfig build() {
            this._checkSingleUse();
            return new TrainedModelConfig(this);
        }
    }
}

