/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.spi;

import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.internal.util.StringHelper;

public enum CascadingFetchProfile {
    MERGE("merge", CascadingActions.MERGE),
    REFRESH("refresh", CascadingActions.REFRESH);

    private final String legacyName;
    private final CascadingAction cascadingAction;

    private CascadingFetchProfile(String legacyName, CascadingAction cascadingAction) {
        this.legacyName = legacyName;
        this.cascadingAction = cascadingAction;
    }

    public String getLegacyName() {
        return this.legacyName;
    }

    public CascadingAction getCascadingAction() {
        return this.cascadingAction;
    }

    public static CascadingFetchProfile fromLegacyName(String legacyName) {
        if (StringHelper.isEmpty(legacyName)) {
            return null;
        }
        if (CascadingFetchProfile.MERGE.legacyName.equalsIgnoreCase(legacyName)) {
            return MERGE;
        }
        if (CascadingFetchProfile.REFRESH.legacyName.equalsIgnoreCase(legacyName)) {
            return REFRESH;
        }
        throw new IllegalArgumentException("Passed name [" + legacyName + "] not recognized as a legacy internal fetch profile name; supported values include: 'merge' and 'refresh'");
    }
}

