/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.gatein.common.logging.LogLevel;
import org.gatein.common.logging.Logger;
import org.slf4j.spi.LocationAwareLogger;

class SLF4JLocationAwareLogger
extends Logger {
    private static final String FQCN = SLF4JLocationAwareLogger.class.getName();
    private final LocationAwareLogger delegate;

    public SLF4JLocationAwareLogger(LocationAwareLogger delegate) {
        this.delegate = delegate;
    }

    @Override
    protected void doLog(LogLevel level, Object msg, Object[] argArray, Throwable throwable) {
        try {
            switch (LOGGER) {
                case 0: {
                    log.invoke((Object)this.delegate, null, FQCN, level.getSLF4Jlevel(), String.valueOf(msg), throwable);
                    break;
                }
                case 1: {
                    log.invoke((Object)this.delegate, null, FQCN, level.getSLF4Jlevel(), String.valueOf(msg), argArray, throwable);
                }
            }
        }
        catch (IllegalAccessException e) {
            AssertionError ae = new AssertionError((Object)"Unexpected issue when using SLF4J location aware logger");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    @Override
    protected org.slf4j.Logger getDelegate() {
        return this.delegate;
    }
}

