/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.storage;

import io.meeds.poll.dao.PollDAO;
import io.meeds.poll.dao.PollOptionDAO;
import io.meeds.poll.dao.PollVoteDAO;
import io.meeds.poll.entity.PollEntity;
import io.meeds.poll.entity.PollOptionEntity;
import io.meeds.poll.entity.PollVoteEntity;
import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.model.PollVote;
import io.meeds.poll.utils.EntityMapper;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class PollStorage {
    private PollDAO pollDAO;
    private PollOptionDAO pollOptionDAO;
    private PollVoteDAO pollVoteDAO;

    public PollStorage(PollDAO pollDAO, PollOptionDAO pollOptionDAO, PollVoteDAO pollVoteDAO) {
        this.pollDAO = pollDAO;
        this.pollOptionDAO = pollOptionDAO;
        this.pollVoteDAO = pollVoteDAO;
    }

    public Poll createPoll(Poll poll, List<PollOption> pollOptions) {
        PollEntity pollEntity = EntityMapper.toPollEntity(poll);
        pollEntity = (PollEntity)this.pollDAO.save(pollEntity);
        for (PollOption pollOption : pollOptions) {
            PollOptionEntity pollOptionEntity = EntityMapper.toPollOptionEntity(pollOption, pollEntity);
            this.pollOptionDAO.save(pollOptionEntity);
        }
        return EntityMapper.fromPollEntity(pollEntity);
    }

    public Poll getPollById(long pollId) {
        PollEntity pollEntity = this.pollDAO.findById(pollId).orElse(null);
        return EntityMapper.fromPollEntity(pollEntity);
    }

    public List<PollOption> getPollOptionsByPollId(long pollId) {
        List<PollOptionEntity> pollOptionEntities = this.pollOptionDAO.findByPollId(pollId);
        return pollOptionEntities.stream().map(po -> EntityMapper.fromPollOptionEntity(po, pollId)).toList();
    }

    public Poll updatePoll(Poll poll) {
        PollEntity pollEntity = EntityMapper.toPollEntity(poll);
        pollEntity = (PollEntity)this.pollDAO.save(pollEntity);
        return EntityMapper.fromPollEntity(pollEntity);
    }

    public PollVote createPollVote(PollVote pollVote) {
        PollOptionEntity pollOptionEntity = (PollOptionEntity)this.pollOptionDAO.findById(pollVote.getPollOptionId()).orElseThrow();
        PollVoteEntity pollVoteEntity = EntityMapper.toPollVoteEntity(pollVote, pollOptionEntity);
        pollVoteEntity = (PollVoteEntity)this.pollVoteDAO.save(pollVoteEntity);
        return EntityMapper.fromPollVoteEntity(pollVoteEntity, pollVote.getPollOptionId());
    }

    public int countPollOptionTotalVotes(long pollOptionId) {
        return this.pollVoteDAO.countByPollOptionId(pollOptionId);
    }

    public int countPollOptionTotalVotesByUser(long pollOptionId, long userId) {
        return this.pollVoteDAO.countByPollOptionIdAndVoterId(pollOptionId, userId);
    }

    public PollOption getPollOptionById(long pollOptionId) {
        PollOptionEntity pollOptionEntity = this.pollOptionDAO.findById(pollOptionId).orElse(null);
        return EntityMapper.fromPollOptionEntity(pollOptionEntity);
    }

    public int countPollOptionsByPollId(long pollId) {
        return this.pollOptionDAO.countByPollId(pollId);
    }

    public int countPollTotalVotes(long pollId) {
        return this.pollVoteDAO.countByPollId(pollId);
    }

    public boolean didVote(long currentUserIdentityId, Long pollId) {
        return this.pollVoteDAO.countByPollIdAndVoterId(pollId, currentUserIdentityId) > 0L;
    }
}

