/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.AzureRepository;
import co.elastic.clients.elasticsearch.snapshot.GcsRepository;
import co.elastic.clients.elasticsearch.snapshot.ReadOnlyUrlRepository;
import co.elastic.clients.elasticsearch.snapshot.Repository;
import co.elastic.clients.elasticsearch.snapshot.S3Repository;
import co.elastic.clients.elasticsearch.snapshot.SharedFileSystemRepository;
import co.elastic.clients.elasticsearch.snapshot.SourceOnlyRepository;
import co.elastic.clients.util.ObjectBuilder;
import java.util.function.Function;

public class RepositoryBuilders {
    private RepositoryBuilders() {
    }

    public static AzureRepository.Builder azure() {
        return new AzureRepository.Builder();
    }

    public static Repository azure(Function<AzureRepository.Builder, ObjectBuilder<AzureRepository>> fn) {
        Repository.Builder builder = new Repository.Builder();
        builder.azure(fn.apply(new AzureRepository.Builder()).build());
        return builder.build();
    }

    public static GcsRepository.Builder gcs() {
        return new GcsRepository.Builder();
    }

    public static Repository gcs(Function<GcsRepository.Builder, ObjectBuilder<GcsRepository>> fn) {
        Repository.Builder builder = new Repository.Builder();
        builder.gcs(fn.apply(new GcsRepository.Builder()).build());
        return builder.build();
    }

    public static ReadOnlyUrlRepository.Builder url() {
        return new ReadOnlyUrlRepository.Builder();
    }

    public static Repository url(Function<ReadOnlyUrlRepository.Builder, ObjectBuilder<ReadOnlyUrlRepository>> fn) {
        Repository.Builder builder = new Repository.Builder();
        builder.url(fn.apply(new ReadOnlyUrlRepository.Builder()).build());
        return builder.build();
    }

    public static S3Repository.Builder s3() {
        return new S3Repository.Builder();
    }

    public static Repository s3(Function<S3Repository.Builder, ObjectBuilder<S3Repository>> fn) {
        Repository.Builder builder = new Repository.Builder();
        builder.s3(fn.apply(new S3Repository.Builder()).build());
        return builder.build();
    }

    public static SharedFileSystemRepository.Builder fs() {
        return new SharedFileSystemRepository.Builder();
    }

    public static Repository fs(Function<SharedFileSystemRepository.Builder, ObjectBuilder<SharedFileSystemRepository>> fn) {
        Repository.Builder builder = new Repository.Builder();
        builder.fs(fn.apply(new SharedFileSystemRepository.Builder()).build());
        return builder.build();
    }

    public static SourceOnlyRepository.Builder source() {
        return new SourceOnlyRepository.Builder();
    }

    public static Repository source(Function<SourceOnlyRepository.Builder, ObjectBuilder<SourceOnlyRepository>> fn) {
        Repository.Builder builder = new Repository.Builder();
        builder.source(fn.apply(new SourceOnlyRepository.Builder()).build());
        return builder.build();
    }
}

