/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.rest;

import io.meeds.crowdin.gamification.rest.HooksManagementRest;
import io.meeds.crowdin.gamification.services.WebhookService;
import io.meeds.crowdin.gamification.storage.CrowdinConsumerStorage;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={HooksManagementRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
class HooksManagementRestTest {
    private static final String HOOKS_PATH = "/hooks";
    private static final String SIMPLE_USER = "simple";
    private static final String ADMIN_USER = "admin";
    private static final String TEST_PASSWORD = "testPassword";
    @MockBean
    private WebhookService webhookService;
    @MockBean
    private CrowdinConsumerStorage crowdinConsumerStorage;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    HooksManagementRestTest() {
    }

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getWebhooksAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks?offset=0&limit=10&includeLanguages=false", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getWebhooksSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks?offset=0&limit=10&includeLanguages=false", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getWebhookByIdAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getWebhookByIdSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getWebhookByIdAdmin() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/0", (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.webhookService)).getWebhookId(1L, ADMIN_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException()}).when((Object)this.webhookService)).getWebhookId(1L, ADMIN_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("Webhook doesn't exist")}).when((Object)this.webhookService)).getWebhookId(1L, ADMIN_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getProjectDirectoriesAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/4/directories", (Object[])new Object[0]).param("offset", new String[]{"0"}).param("limit", new String[]{"10"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getProjectDirectoriesSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/4/directories", (Object[])new Object[0]).param("offset", new String[]{"0"}).param("limit", new String[]{"10"}).with(this.testSimpleUser()));
        ((WebhookService)Mockito.verify((Object)this.webhookService, (VerificationMode)Mockito.times((int)1))).getProjectDirectories(4L, SIMPLE_USER, 0, 10);
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.webhookService)).getProjectDirectories(4L, SIMPLE_USER, 0, 10);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/4/directories", (Object[])new Object[0]).param("offset", new String[]{"0"}).param("limit", new String[]{"10"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException()}).when((Object)this.webhookService)).getProjectDirectories(4L, SIMPLE_USER, 0, 10);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/4/directories", (Object[])new Object[0]).param("offset", new String[]{"0"}).param("limit", new String[]{"10"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("Webhook with project id '4' doesn't exist")}).when((Object)this.webhookService)).getProjectDirectories(4L, SIMPLE_USER, 0, 10);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/4/directories", (Object[])new Object[0]).param("offset", new String[]{"0"}).param("limit", new String[]{"10"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getProjectsAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/projects", (Object[])new Object[0]).param("hookId", new String[]{"hookId"}).param("accessToken", new String[]{"accessToken"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getProjectsSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/projects", (Object[])new Object[0]).param("hookId", new String[]{"hookId"}).param("accessToken", new String[]{"accessToken"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getProjectsAdmin() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/projects", (Object[])new Object[0]).param("accessToken", new String[]{"accessToken"}).param("hookId", new String[]{"1232"}).with(this.testAdminUser()));
        ((WebhookService)Mockito.verify((Object)this.webhookService, (VerificationMode)Mockito.times((int)1))).getProjectsFromWebhookId(1232L);
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void createWebhookAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)HOOKS_PATH, (Object[])new Object[0]).param("projectId", new String[]{"1"}).param("projectName", new String[]{"projectName"}).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void createWebhookSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)HOOKS_PATH, (Object[])new Object[0]).param("projectId", new String[]{"1"}).param("projectName", new String[]{"projectName"}).param("accessToken", new String[]{"accessToken"}).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void createWebhookAdmin() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)HOOKS_PATH, (Object[])new Object[0]).param("projectId", new String[]{"1"}).param("projectName", new String[]{"projectName"}).param("accessToken", new String[]{"accessToken"}).with(this.testAdminUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isCreated());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.webhookService)).createWebhook(1L, "projectName", "accessToken", ADMIN_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)HOOKS_PATH, (Object[])new Object[0]).param("projectId", new String[]{"1"}).param("projectName", new String[]{"projectName"}).param("accessToken", new String[]{"accessToken"}).with(this.testAdminUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectAlreadyExistsException(null)}).when((Object)this.webhookService)).createWebhook(1L, "projectName", "accessToken", ADMIN_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)HOOKS_PATH, (Object[])new Object[0]).param("projectId", new String[]{"1"}).param("projectName", new String[]{"projectName"}).param("accessToken", new String[]{"accessToken"}).with(this.testAdminUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isConflict());
    }

    @Test
    void updateWebHookAccessTokenAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)HOOKS_PATH, (Object[])new Object[0]).param("webHookId", new String[]{"1"}).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateWebHookAccessTokenSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)HOOKS_PATH, (Object[])new Object[0]).param("webHookId", new String[]{"1"}).param("accessToken", new String[]{"accessToken"}).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateWebHookAccessTokenAdmin() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)HOOKS_PATH, (Object[])new Object[0]).param("webHookId", new String[]{"1"}).param("accessToken", new String[]{"accessToken"}).with(this.testAdminUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void deleteWebhookHookAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/hooks/4", (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deleteWebhookHookSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/hooks/4", (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deleteWebhookHookTokenAdmin() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/hooks/4", (Object[])new Object[0]).with(this.testAdminUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    private RequestPostProcessor testAdminUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)ADMIN_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("rewarding")});
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

