/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.service;

import io.meeds.crowdin.gamification.model.Event;
import io.meeds.crowdin.gamification.services.CrowdinTriggerService;
import io.meeds.crowdin.gamification.storage.WebHookStorage;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.TriggerService;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@SpringBootTest(classes={CrowdinTriggerService.class})
class CrowdinTriggerServiceTest {
    private static final String USER = "user";
    @MockBean
    private TriggerService triggerService;
    @MockBean
    private ConnectorService connectorService;
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private WebHookStorage webHookStorage;
    @MockBean
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private CrowdinTriggerService crowdinTriggerService;

    CrowdinTriggerServiceTest() {
    }

    @Test
    void testProcessEvents() {
        Event event = new Event("stringComment.created", USER, USER, "1", "objectType", "123", "1", true, "1", false, 3);
        Event event1 = new Event("stringComment.deleted", USER, USER, "1", "objectType", "123", "1", true, "1", false, 4);
        Mockito.when((Object)this.triggerService.isTriggerEnabledForAccount("stringComment.created", 123L)).thenReturn((Object)true);
        Mockito.when((Object)this.triggerService.isTriggerEnabledForAccount("stringComment.deleted", 123L)).thenReturn((Object)false);
        Mockito.when((Object)this.connectorService.getAssociatedUsername("crowdin", USER)).thenReturn((Object)"1");
        String eventDetails = "{projectId: " + event.getProjectId() + ", languageId: " + event.getLanguageId() + ", mustBeHuman: " + event.isMustBeHuman() + ", directoryId: " + event.getDirectoryId() + ", totalTargetItem: " + event.getTotalWords() + "}";
        this.crowdinTriggerService.processEvents(List.of(event1, event), "123");
        HashMap<String, Object> gam = new HashMap<String, Object>();
        gam.put("senderId", "1");
        gam.put("receiverId", "1");
        gam.put("objectId", event.getObjectId());
        gam.put("objectType", event.getObjectType());
        gam.put("eventDetails", eventDetails);
        gam.put("ruleTitle", event.getName());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.gamification.generic.action", gam, (Object)"");
    }
}

