/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.storage;

import io.meeds.evm.gamification.dao.EvmTransactionDAO;
import io.meeds.evm.gamification.entity.EvmTransactionEntity;
import io.meeds.evm.gamification.model.EvmTransaction;
import io.meeds.evm.gamification.utils.EntityMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class EvmTransactionStorage {
    @Autowired
    private EvmTransactionDAO evmTransactionDAO;

    public EvmTransaction saveEvmTransaction(EvmTransaction evmTransaction) {
        EvmTransactionEntity evmTransactionEntity = EntityMapper.toEntity(evmTransaction);
        evmTransactionEntity = (EvmTransactionEntity)this.evmTransactionDAO.save(evmTransactionEntity);
        return EntityMapper.fromEntity(evmTransactionEntity);
    }

    public List<String> getDistinctWalletAddresses(String contractAddress, Long ruleCreationDate, Long networkId) {
        return this.evmTransactionDAO.findDistinctAddresses(contractAddress, ruleCreationDate, networkId);
    }

    public List<EvmTransaction> getToAddressFilteredTransactions(String contractAddress, Long networkId, Long transactionDate, String toAddress) {
        List<EvmTransactionEntity> evmTransactionsEntities = this.evmTransactionDAO.findByContractAddressAndNetworkIdAndToAddressAndTransactionDateGreaterThan(contractAddress, networkId, toAddress, transactionDate);
        return evmTransactionsEntities.stream().map(td -> EntityMapper.fromEntity(td)).toList();
    }

    public List<EvmTransaction> getFromAddressFilteredTransactions(String contractAddress, Long networkId, Long transactionDate, String fromAddress) {
        List<EvmTransactionEntity> evmTransactionsEntities = this.evmTransactionDAO.findByContractAddressAndNetworkIdAndFromAddressAndTransactionDateGreaterThan(contractAddress, networkId, fromAddress, transactionDate);
        return evmTransactionsEntities.stream().map(td -> EntityMapper.fromEntity(td)).toList();
    }

    public EvmTransaction getLastScannedTransactionByWalletAddress(String contractAddress, Long networkId, String walletAddress) {
        EvmTransactionEntity lastTransactionEntity = this.evmTransactionDAO.findTopByContractAddressAndNetworkIdAndFromAddressOrderByIdDesc(contractAddress, networkId, walletAddress);
        return EntityMapper.fromEntity(lastTransactionEntity);
    }
}

