/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.service;

import io.meeds.evm.gamification.blockchain.BlockchainConfiguration;
import io.meeds.evm.gamification.model.EvmContract;
import io.meeds.evm.gamification.model.EvmTransaction;
import io.meeds.evm.gamification.service.EvmTransactionService;
import io.meeds.evm.gamification.utils.Utils;
import io.meeds.gamification.model.RuleDTO;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.EventValues;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes4;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;

@Service
public class EvmBlockchainService {
    private static final Log LOG = ExoLogger.getLogger(EvmBlockchainService.class);
    private static final Function FUNC_DECIMALS = new Function("decimals", Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(){}));
    private static final Function FUNC_SYMBOL = new Function("symbol", Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
    private static final Function FUNC_NAME = new Function("name", Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
    @Autowired
    BlockchainConfiguration blockchainConfiguration;
    @Autowired
    private EvmTransactionService evmTransactionService;

    public void saveTokenTransactions(long fromBlock, long toBlock, String contractAddress, String blockchainNetwork, long networkId) {
        Event event = Utils.TRANSFER_EVENT_ERC20;
        if (this.isERC1155(blockchainNetwork, contractAddress)) {
            event = Utils.TRANSFERSINGLE_EVENT;
        } else if (this.isERC721(blockchainNetwork, contractAddress)) {
            event = Utils.TRANSFER_EVENT_ER721;
        }
        List<EvmTransaction> transferEvents = this.getEvmTransactions(fromBlock, toBlock, contractAddress, blockchainNetwork, event);
        if (transferEvents != null && !transferEvents.isEmpty()) {
            transferEvents.forEach(transferEvent -> {
                transferEvent.setContractAddress(contractAddress);
                transferEvent.setNetworkId(networkId);
                transferEvent.setTransactionDate(System.currentTimeMillis());
                this.evmTransactionService.saveTransaction((EvmTransaction)transferEvent);
            });
        }
    }

    public List<EvmTransaction> getEvmTransactions(long fromBlock, long toBlock, String contractAddress, String blockchainNetwork, Event event) {
        Web3j networkWeb3j = this.blockchainConfiguration.getNetworkWeb3j(blockchainNetwork);
        EthFilter ethFilter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), contractAddress);
        ethFilter.addSingleTopic(EventEncoder.encode((Event)event));
        try {
            EthLog ethLog = (EthLog)networkWeb3j.ethGetLogs(ethFilter).send();
            List ethLogs = ethLog.getLogs();
            if (CollectionUtils.isEmpty((Collection)ethLogs)) {
                return Collections.emptyList();
            }
            return ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).collect(Collectors.toMap(org.web3j.protocol.core.methods.response.Log::getTransactionHash, log -> log, (existing, replacement) -> existing)).values().stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(org.web3j.protocol.core.methods.response.Log::getTransactionHash).map(transactionHash -> this.getTransactionReceipt((String)transactionHash, networkWeb3j)).filter(TransactionReceipt::isStatusOK).flatMap(transactionReceipt -> this.getTransferEvents((TransactionReceipt)transactionReceipt, contractAddress, blockchainNetwork, event)).toList();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving event logs", e);
        }
    }

    public EvmContract getTokenDetails(String contractAddress, String blockchainNetwork) {
        try {
            Web3j networkWeb3j = this.blockchainConfiguration.getNetworkWeb3j(blockchainNetwork);
            EvmContract token = new EvmContract();
            token.setType(this.detectTokenType(blockchainNetwork, contractAddress));
            if (token.getType().equals("ERC-20")) {
                BigInteger decimals = new BigInteger(this.callFunction(networkWeb3j, contractAddress, FUNC_DECIMALS));
                token.setDecimals(decimals);
            }
            String name = this.getTokenName(networkWeb3j, contractAddress, token.getType());
            token.setName(name);
            String symbol = this.getTokenSymbol(networkWeb3j, contractAddress, token.getType());
            token.setSymbol(symbol);
            return token;
        }
        catch (Exception e) {
            LOG.info((Object)"the error", (Throwable)e);
            return null;
        }
    }

    public String detectTokenType(String blockchainNetwork, String contractAddress) {
        try {
            Web3j web3j = this.blockchainConfiguration.getNetworkWeb3j(blockchainNetwork);
            if (this.supportsInterface(web3j, contractAddress, "0x80ac58cd")) {
                return "ERC-721";
            }
            if (this.supportsInterface(web3j, contractAddress, "0xd9b67a26")) {
                return "ERC-1155";
            }
            if (!new BigInteger(this.callFunction(web3j, contractAddress, FUNC_DECIMALS)).equals(BigInteger.ZERO)) {
                return "ERC-20";
            }
        }
        catch (Exception e) {
            LOG.debug("Error when detecting token type of contract '{}' on blockchain networdk '{}'", new Object[]{contractAddress, blockchainNetwork, e});
        }
        return "Unknown type token";
    }

    public boolean isERC1155(String blockchainNetwork, String contractAddress) {
        return this.detectTokenType(blockchainNetwork, contractAddress).equals("ERC-1155");
    }

    public boolean isERC721(String blockchainNetwork, String contractAddress) {
        return this.detectTokenType(blockchainNetwork, contractAddress).equals("ERC-721");
    }

    private boolean supportsInterface(Web3j web3j, String tokenAddress, String interfaceId) throws Exception {
        Function supportsInterfaceFunction = new Function("supportsInterface", Arrays.asList(new Bytes4(Utils.hexStringToByteArray(interfaceId))), Arrays.asList(new TypeReference<Bool>(this){}));
        String encodedFunction = FunctionEncoder.encode((Function)supportsInterfaceFunction);
        EthCall response = (EthCall)web3j.ethCall(Transaction.createEthCallTransaction((String)"0x0000000000000000000000000000000000000000", (String)tokenAddress, (String)encodedFunction), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        String value = response.getValue();
        if (value != null) {
            if (value.startsWith("0x")) {
                value = value.substring(2);
            }
            value = value.replaceFirst("^0+(?!$)", "");
            return value.equals("1");
        }
        return false;
    }

    private String callFunction(Web3j web3j, String contractAddress, Function function) throws Exception {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        EthCall response = (EthCall)web3j.ethCall(Transaction.createEthCallTransaction((String)contractAddress, (String)contractAddress, (String)encodedFunction), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        List result = FunctionReturnDecoder.decode((String)response.getValue(), (List)function.getOutputParameters());
        if (((TypeReference)function.getOutputParameters().get(0)).getType().equals(Utf8String.class)) {
            return ((Utf8String)result.get(0)).getValue();
        }
        if (((TypeReference)function.getOutputParameters().get(0)).getType().equals(Uint8.class)) {
            return String.valueOf(((Uint8)result.get(0)).getValue());
        }
        if (((TypeReference)function.getOutputParameters().get(0)).getType().equals(Uint256.class)) {
            return String.valueOf(((Uint256)result.get(0)).getValue());
        }
        return "Unexpected output type";
    }

    private String getTokenName(Web3j web3j, String contractAddress, String tokenType) throws Exception {
        if ("ERC-20".equals(tokenType) || "ERC-721".equals(tokenType)) {
            return this.callFunction(web3j, contractAddress, FUNC_NAME);
        }
        return "Unknown name token";
    }

    private String getTokenSymbol(Web3j web3j, String contractAddress, String tokenType) throws Exception {
        if ("ERC-20".equals(tokenType) || "ERC-721".equals(tokenType)) {
            return this.callFunction(web3j, contractAddress, FUNC_SYMBOL);
        }
        return "Unknown symbol token";
    }

    public long getLastBlock(String blockchainNetwork) {
        try {
            Web3j networkWeb3j = this.blockchainConfiguration.getNetworkWeb3j(blockchainNetwork);
            return ((EthBlockNumber)networkWeb3j.ethBlockNumber().send()).getBlockNumber().longValue();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error getting last block number", e);
        }
    }

    public BigInteger balanceOf(String contractAddress, String blockchainNetwork, Map<String, String> functionParams) {
        try {
            boolean isERC1155 = this.isERC1155(blockchainNetwork, contractAddress);
            Web3j networkWeb3j = this.blockchainConfiguration.getNetworkWeb3j(blockchainNetwork);
            Function FUNC_BALANCEOF = isERC1155 ? new Function("balanceOf", Arrays.asList(new Address(160, functionParams.get("owner")), new Uint256(new BigInteger(functionParams.get("tokenId")))), Arrays.asList(new TypeReference<Uint256>(this){})) : new Function("balanceOf", Arrays.asList(new Address(160, functionParams.get("owner"))), Arrays.asList(new TypeReference<Uint256>(this){}));
            return new BigInteger(this.callFunction(networkWeb3j, contractAddress, FUNC_BALANCEOF));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error calling balanceOf method", e);
        }
    }

    public boolean isBalanceEnough(String contractAddress, String blockchainNetwork, String walletAddress, RuleDTO rule, List<EvmTransaction> transactions) {
        BigInteger balanceOf;
        boolean isERC1155 = this.isERC1155(blockchainNetwork, contractAddress);
        HashMap<String, String> funcParams = new HashMap<String, String>();
        funcParams.put("owner", walletAddress);
        String minAmount = (String)rule.getEvent().getProperties().get("minAmount");
        BigInteger desiredMinAmount = new BigInteger(minAmount);
        if (isERC1155) {
            BigInteger finalDesiredMinAmount = desiredMinAmount;
            return transactions.stream().anyMatch(transaction -> {
                funcParams.put("tokenId", transaction.getTokenId().toString());
                BigInteger balanceOf = this.balanceOf(contractAddress, blockchainNetwork, funcParams);
                return balanceOf.compareTo(finalDesiredMinAmount) >= 0;
            });
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)rule.getEvent().getProperties().get("tokenDecimals")))) {
            BigInteger base = new BigInteger("10");
            Integer decimals = Integer.parseInt((String)rule.getEvent().getProperties().get("tokenDecimals"));
            desiredMinAmount = base.pow(decimals).multiply(desiredMinAmount);
        }
        return (balanceOf = this.balanceOf(contractAddress, blockchainNetwork, funcParams)).compareTo(desiredMinAmount) >= 0;
    }

    private Stream<EvmTransaction> getTransferEvents(TransactionReceipt transactionReceipt, String contractAddress, String blockchainNetwork, Event event) {
        try {
            List<TransferEventResponse> transferEvents = this.getTransactionTransferEvents(transactionReceipt, contractAddress, event);
            if (transferEvents != null && !transferEvents.isEmpty()) {
                return transferEvents.stream().map(transferEventResponse -> {
                    EvmTransaction transferEvent = new EvmTransaction();
                    HashMap<String, String> funcParams = new HashMap<String, String>();
                    funcParams.put("owner", transferEventResponse.to);
                    if (transferEventResponse.tokenId != null) {
                        funcParams.put("tokenId", transferEventResponse.tokenId.toString());
                        transferEvent.setTokenId(transferEventResponse.tokenId);
                    }
                    transferEvent.setTransactionHash(transferEventResponse.log.getTransactionHash());
                    transferEvent.setBlockHash(transferEventResponse.log.getBlockHash());
                    transferEvent.setBlockNumber(transferEventResponse.log.getBlockNumber());
                    transferEvent.setFromAddress(transferEventResponse.from);
                    transferEvent.setToAddress(transferEventResponse.to);
                    transferEvent.setAmount(transferEventResponse.value);
                    transferEvent.setWalletBalance(this.balanceOf(contractAddress, blockchainNetwork, funcParams));
                    return transferEvent;
                });
            }
        }
        catch (Exception e) {
            LOG.warn("Error while getting Transfer events on transaction with hash {}. This might happen when an incompatible 'Transfer' event is detected", new Object[]{transactionReceipt.getTransactionHash(), e});
        }
        return Stream.empty();
    }

    private TransactionReceipt getTransactionReceipt(String transactionHash, Web3j customWeb3j) {
        try {
            EthGetTransactionReceipt ethGetTransactionReceipt = (EthGetTransactionReceipt)customWeb3j.ethGetTransactionReceipt(transactionHash).send();
            if (ethGetTransactionReceipt != null) {
                return (TransactionReceipt)ethGetTransactionReceipt.getResult();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving Receipt for Transaction with hash: " + transactionHash, e);
        }
        return null;
    }

    public List<TransferEventResponse> getTransactionTransferEvents(TransactionReceipt transactionReceipt, String contractAddress, Event event) {
        List<EventValuesWithLog> valueList = this.extractEventParametersWithLog(event, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (EventValuesWithLog eventValues : valueList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)contractAddress, (CharSequence)eventValues.getLog().getAddress())) continue;
            if (event.equals(Utils.TRANSFER_EVENT_ERC20)) {
                if (CollectionUtils.isEmpty(eventValues.getIndexedValues())) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The indexed values size is 0", new Object[]{transactionReceipt.getTransactionHash()});
                    continue;
                }
                if (eventValues.getIndexedValues().size() != 2) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The indexed values size is {} while it's expected to be '2'", new Object[]{transactionReceipt.getTransactionHash(), eventValues.getIndexedValues().size()});
                    continue;
                }
                if (CollectionUtils.isEmpty(eventValues.getNonIndexedValues())) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The non-indexed values size is 0", new Object[]{transactionReceipt.getTransactionHash()});
                    continue;
                }
                if (eventValues.getNonIndexedValues().size() != 1) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The non-indexed values size is {} while it's expected to be '1'", new Object[]{transactionReceipt.getTransactionHash(), eventValues.getNonIndexedValues().size()});
                    continue;
                }
            }
            if (event.equals(Utils.TRANSFER_EVENT_ER721)) {
                if (CollectionUtils.isEmpty(eventValues.getIndexedValues())) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The indexed values size is 0", new Object[]{transactionReceipt.getTransactionHash()});
                    continue;
                }
                if (eventValues.getIndexedValues().size() != 3) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The indexed values size is {} while it's expected to be '3'", new Object[]{transactionReceipt.getTransactionHash(), eventValues.getIndexedValues().size()});
                    continue;
                }
                if (eventValues.getNonIndexedValues().size() != 0) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The non-indexed values size is {} while it's expected to be '0'", new Object[]{transactionReceipt.getTransactionHash(), eventValues.getNonIndexedValues().size()});
                    continue;
                }
            }
            if (event.equals(Utils.TRANSFERSINGLE_EVENT)) {
                if (CollectionUtils.isEmpty(eventValues.getIndexedValues())) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The indexed values size is 0", new Object[]{transactionReceipt.getTransactionHash()});
                    continue;
                }
                if (eventValues.getIndexedValues().size() != 3) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The indexed values size is {} while it's expected to be '3'", new Object[]{transactionReceipt.getTransactionHash(), eventValues.getIndexedValues().size()});
                    continue;
                }
                if (CollectionUtils.isEmpty(eventValues.getNonIndexedValues())) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The non-indexed values size is 0", new Object[]{transactionReceipt.getTransactionHash()});
                    continue;
                }
                if (eventValues.getNonIndexedValues().size() != 2) {
                    LOG.info("Can't parse 'Transfer' event logs of transaction with hash {}. The non-indexed values size is {} while it's expected to be '2'", new Object[]{transactionReceipt.getTransactionHash(), eventValues.getNonIndexedValues().size()});
                    continue;
                }
            }
            TransferEventResponse typedResponse = this.newTransferEventResponse(eventValues, event);
            responses.add(typedResponse);
        }
        return responses;
    }

    private TransferEventResponse newTransferEventResponse(EventValuesWithLog eventValues, Event event) {
        TransferEventResponse typedResponse = new TransferEventResponse();
        typedResponse.log = eventValues.getLog();
        if (event.equals(Utils.TRANSFER_EVENT_ERC20)) {
            typedResponse.from = (String)eventValues.getIndexedValues().get(0).getValue();
            typedResponse.to = (String)eventValues.getIndexedValues().get(1).getValue();
            typedResponse.value = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
        } else if (event.equals(Utils.TRANSFER_EVENT_ER721)) {
            typedResponse.from = (String)eventValues.getIndexedValues().get(0).getValue();
            typedResponse.to = (String)eventValues.getIndexedValues().get(1).getValue();
            typedResponse.tokenId = (BigInteger)eventValues.getIndexedValues().get(2).getValue();
        } else if (event.equals(Utils.TRANSFERSINGLE_EVENT)) {
            typedResponse.from = (String)eventValues.getIndexedValues().get(1).getValue();
            typedResponse.to = (String)eventValues.getIndexedValues().get(2).getValue();
            typedResponse.tokenId = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.value = (BigInteger)eventValues.getNonIndexedValues().get(1).getValue();
        }
        return typedResponse;
    }

    protected List<EventValuesWithLog> extractEventParametersWithLog(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParametersWithLog(event, (org.web3j.protocol.core.methods.response.Log)log)).filter(Objects::nonNull).toList();
    }

    protected EventValuesWithLog extractEventParametersWithLog(Event event, org.web3j.protocol.core.methods.response.Log log) {
        return EvmBlockchainService.staticExtractEventParametersWithLog(event, log);
    }

    protected static EventValuesWithLog staticExtractEventParametersWithLog(Event event, org.web3j.protocol.core.methods.response.Log log) {
        EventValues eventValues = Contract.staticExtractEventParameters((Event)event, (org.web3j.protocol.core.methods.response.Log)log);
        return eventValues == null ? null : new EventValuesWithLog(eventValues, log);
    }

    public static class EventValuesWithLog {
        private final EventValues eventValues;
        private final org.web3j.protocol.core.methods.response.Log log;

        public EventValuesWithLog(EventValues eventValues, org.web3j.protocol.core.methods.response.Log log) {
            this.eventValues = eventValues;
            this.log = log;
        }

        public List<Type> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<Type> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }

        public org.web3j.protocol.core.methods.response.Log getLog() {
            return this.log;
        }
    }

    public static class TransferEventResponse {
        private org.web3j.protocol.core.methods.response.Log log;
        private String from;
        private String to;
        private BigInteger value;
        private BigInteger tokenId;
    }
}

