/*
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2024 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.evm.gamification.dao;

import io.meeds.evm.gamification.entity.EvmTransactionEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface EvmTransactionDAO extends JpaRepository<EvmTransactionEntity, Long> {

  EvmTransactionEntity findTopByContractAddressAndNetworkIdAndFromAddressOrderByIdDesc(String contractAddress, Long networkId, String fromAddress);
  @Query("""
          SELECT DISTINCT fromAddress AS address FROM EvmTransaction tr
          WHERE tr.contractAddress = ?1 AND tr.transactionDate >= ?2 AND tr.networkId = ?3
          UNION
          SELECT DISTINCT toAddress AS address FROM EvmTransaction tr
          WHERE tr.contractAddress = ?1 AND tr.transactionDate >= ?2 AND tr.networkId = ?3
      """)
  List<String> findDistinctAddresses(String contractAddress, Long ruleCreationDate, Long networkId);

  List<EvmTransactionEntity> findByContractAddressAndNetworkIdAndToAddressAndTransactionDateGreaterThan(String contractAddress,
                                                                                                        Long networkId,
                                                                                                        String toAddress,
                                                                                                        Long transactionDate);

  List<EvmTransactionEntity> findByContractAddressAndNetworkIdAndFromAddressAndTransactionDateGreaterThan(String contractAddress,
                                                                                                          Long networkId,
                                                                                                          String fromAddress,
                                                                                                          Long transactionDate);
}
