/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.scheduling.task;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.evm.gamification.scheduling.task.EvmContractSaveTask$AjcClosure1;
import io.meeds.evm.gamification.scheduling.task.EvmContractSaveTask$AjcClosure3;
import io.meeds.evm.gamification.scheduling.task.EvmContractSaveTask$AjcClosure5;
import io.meeds.evm.gamification.service.EvmBlockchainService;
import io.meeds.evm.gamification.service.EvmContractTransferService;
import io.meeds.gamification.model.RuleDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class EvmContractSaveTask {
    private static final Logger LOG;
    private static final Scope SETTING_SCOPE;
    private static final Context SETTING_CONTEXT;
    private static final String SETTING_LAST_TIME_CHECK_KEY = "transferredTokenTransactionsCheck";
    @Autowired
    private SettingService settingService;
    @Autowired
    private EvmBlockchainService evmBlockchainService;
    @Autowired
    private EvmContractTransferService evmContractTransferService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    @ContainerTransactional
    @Scheduled(cron="${gamification.evm.transactionSave.cron:0 */15 * * * *}")
    public synchronized void saveEVMContractTransactions() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        EvmContractSaveTask$AjcClosure1 evmContractSaveTask$AjcClosure1 = new EvmContractSaveTask$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(evmContractSaveTask$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ContainerTransactional
    public long getLastCheckedBlock(String contractAddress, String networkId) {
        String string = contractAddress;
        String string2 = networkId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        EvmContractSaveTask$AjcClosure3 evmContractSaveTask$AjcClosure3 = new EvmContractSaveTask$AjcClosure3(objectArray);
        return Conversions.longValue((Object)ContainerTransactionalAspect.aspectOf().around(evmContractSaveTask$AjcClosure3.linkClosureAndJoinPoint(69648)));
    }

    @ContainerTransactional
    public void saveLastCheckedBlock(long lastBlock, String contractAddress, String networkId) {
        long l = lastBlock;
        String string = contractAddress;
        String string2 = networkId;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), string, string2, joinPoint};
        EvmContractSaveTask$AjcClosure5 evmContractSaveTask$AjcClosure5 = new EvmContractSaveTask$AjcClosure5(objectArray2);
        ContainerTransactionalAspect.aspectOf().around(evmContractSaveTask$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    static {
        EvmContractSaveTask.ajc$preClinit();
        LOG = LoggerFactory.getLogger(EvmContractSaveTask.class);
        SETTING_SCOPE = Scope.APPLICATION.id("GAMIFICATION_EVM");
        SETTING_CONTEXT = Context.GLOBAL.id("GAMIFICATION_EVM");
    }

    static final /* synthetic */ void saveEVMContractTransactions_aroundBody0(EvmContractSaveTask ajc$this, JoinPoint joinPoint) {
        try {
            List<RuleDTO> evmRules = ajc$this.evmContractTransferService.getEvmRules();
            if (CollectionUtils.isNotEmpty(evmRules)) {
                LOG.info("Start listening evm token transfers for {} configured rules", (Object)evmRules.size());
                ArrayList rules = new ArrayList();
                evmRules.forEach(rule -> {
                    boolean isRuleExists = false;
                    if (rules != null) {
                        isRuleExists = rules.stream().anyMatch(ruleDTO -> ((String)ruleDTO.getEvent().getProperties().get("networkId")).compareTo((String)rule.getEvent().getProperties().get("networkId")) == 0 && StringUtils.equals((CharSequence)((String)ruleDTO.getEvent().getProperties().get("contractAddress")).toLowerCase(), (CharSequence)((String)rule.getEvent().getProperties().get("contractAddress")).toLowerCase()));
                    }
                    if (!isRuleExists) {
                        String blockchainNetwork = (String)rule.getEvent().getProperties().get("blockchainNetwork");
                        String contractAddress = (String)rule.getEvent().getProperties().get("contractAddress");
                        String networkId = (String)rule.getEvent().getProperties().get("networkId");
                        long lastBlock = this.evmBlockchainService.getLastBlock(blockchainNetwork);
                        long lastCheckedBlock = this.getLastCheckedBlock(contractAddress, networkId);
                        if (lastCheckedBlock == 0L) {
                            this.saveLastCheckedBlock(lastBlock, contractAddress, networkId);
                            return;
                        }
                        this.evmBlockchainService.saveTokenTransactions(lastCheckedBlock + 1L, lastBlock, contractAddress.toLowerCase(), blockchainNetwork, Long.parseLong(networkId));
                        this.saveLastCheckedBlock(lastBlock, contractAddress, networkId);
                        rules.add(rule);
                    }
                });
                LOG.info("End listening evm token transfers");
            }
        }
        catch (Exception e) {
            LOG.error("An error occurred while listening blockchain transactions", (Throwable)e);
        }
    }

    static final /* synthetic */ long getLastCheckedBlock_aroundBody2(EvmContractSaveTask ajc$this, String contractAddress, String networkId, JoinPoint joinPoint) {
        long lastCheckedBlock = 0L;
        SettingValue settingValue = ajc$this.settingService.get(SETTING_CONTEXT, SETTING_SCOPE, SETTING_LAST_TIME_CHECK_KEY + networkId + "#" + contractAddress);
        if (settingValue != null && settingValue.getValue() != null) {
            lastCheckedBlock = Long.parseLong(settingValue.getValue().toString());
        }
        return lastCheckedBlock;
    }

    static final /* synthetic */ void saveLastCheckedBlock_aroundBody4(EvmContractSaveTask ajc$this, long lastBlock, String contractAddress, String networkId, JoinPoint joinPoint) {
        ajc$this.settingService.set(SETTING_CONTEXT, SETTING_SCOPE, SETTING_LAST_TIME_CHECK_KEY + networkId + "#" + contractAddress, SettingValue.create((Long)lastBlock));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EvmContractSaveTask.java", EvmContractSaveTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "saveEVMContractTransactions", "io.meeds.evm.gamification.scheduling.task.EvmContractSaveTask", "", "", "", "void"), 63);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastCheckedBlock", "io.meeds.evm.gamification.scheduling.task.EvmContractSaveTask", "java.lang.String:java.lang.String", "contractAddress:networkId", "", "long"), 106);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveLastCheckedBlock", "io.meeds.evm.gamification.scheduling.task.EvmContractSaveTask", "long:java.lang.String:java.lang.String", "lastBlock:contractAddress:networkId", "", "void"), 118);
    }
}

