/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.utils;

import io.meeds.evm.gamification.model.EvmTransaction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.generated.Uint256;

public class Utils {
    public static final String CONNECTOR_NAME = "evm";
    public static final String SEND_TOKEN_EVENT = "sendToken";
    public static final String RECEIVE_TOKEN_EVENT = "receiveToken";
    public static final String HOLD_TOKEN_EVENT = "holdToken";
    public static final String WALLET_ADDRESS = "walletAddress";
    public static final String CONTRACT_ADDRESS = "contractAddress";
    public static final String BLOCKCHAIN_NETWORK = "blockchainNetwork";
    public static final String NETWORK_ID = "networkId";
    public static final String DECIMALS = "tokenDecimals";
    public static final String MIN_AMOUNT = "minAmount";
    public static final String TARGET_ADDRESS = "targetAddress";
    public static final String DURATION = "duration";
    public static final String SENT_DATE = "sentDate";
    public static final String TOKEN_BALANCE = "tokenBalance";
    public static final String TOKEN_DECIMALS = "tokenDecimals";
    public static final Integer BLOCK_TIME_AVERAGE = 13;
    public static final String ERC721_INTERFACE_ID = "0x80ac58cd";
    public static final String ERC1155_INTERFACE_ID = "0xd9b67a26";
    public static final Event TRANSFER_EVENT_ERC20 = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(false){}));
    public static final Event TRANSFER_EVENT_ER721 = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(true){}));
    public static final Event TRANSFERSINGLE_EVENT = new Event("TransferSingle", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(false){}, new TypeReference<Uint256>(false){}));

    private Utils() {
    }

    public static Map<String, String> stringToMap(String mapAsString) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        mapAsString = mapAsString.substring(1, mapAsString.length() - 1);
        for (String pair : pairs = mapAsString.split(", ")) {
            String[] keyValue = pair.split(": ");
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            map.put(key, value);
        }
        return map;
    }

    public static long convertDateStringToTimestamp(String dateInString) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyy-MM-dd'T'HH:mm:ss.SSSXXX");
        try {
            Date creationDate = formatter.parse(dateInString);
            return creationDate.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date format", e);
        }
    }

    public static Boolean isValidDurationHoldingToken(EvmTransaction transaction, Long desiredDuration) {
        Long holdingDuration = System.currentTimeMillis() - transaction.getTransactionDate();
        return holdingDuration.compareTo(desiredDuration) >= 0;
    }

    public static byte[] hexStringToByteArray(String hexString) {
        if (hexString.startsWith("0x")) {
            hexString = hexString.substring(2);
        }
        if (hexString.length() != 8) {
            throw new IllegalArgumentException("Hex string must be exactly 8 characters long for Bytes4");
        }
        byte[] byteArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byteArray[i] = (byte)Integer.parseInt(hexString.substring(i * 2, i * 2 + 2), 16);
        }
        return byteArray;
    }
}

