/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.github.plugin;

import io.meeds.gamification.github.model.Event;
import io.meeds.gamification.github.plugin.GithubTriggerPlugin;
import io.meeds.gamification.github.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CommentTriggerPlugin
extends GithubTriggerPlugin {
    @Override
    public List<Event> getEvents(Map<String, Object> payload) {
        String eventType;
        String pullRequest = Utils.extractSubItem(payload, "issue", "pull_request");
        String action = Utils.extractSubItem(payload, "action");
        String comment = Utils.extractSubItem(payload, "comment", "html_url");
        String userId = Utils.extractSubItem(payload, "sender", "login");
        String string = eventType = StringUtils.isBlank((CharSequence)pullRequest) ? "githubCommentIssue" : "githubCommentPR";
        if (action != null) {
            String eventName;
            switch (action) {
                case "created": {
                    eventName = StringUtils.isBlank((CharSequence)pullRequest) ? "commentIssue" : "commentPullRequest";
                    break;
                }
                case "deleted": {
                    eventName = StringUtils.isBlank((CharSequence)pullRequest) ? "deleteIssueComment" : "deletePullRequestComment";
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            return Collections.singletonList(new Event(eventName, null, userId, comment, eventType, Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        return Collections.emptyList();
    }
}

