/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.github;

import io.meeds.gamification.github.dao.WebHookDAO;
import io.meeds.gamification.github.services.GithubConsumerService;
import io.meeds.gamification.github.services.GithubTriggerService;
import io.meeds.gamification.github.services.WebhookService;
import io.meeds.gamification.github.services.impl.GithubTriggerServiceImpl;
import io.meeds.gamification.github.services.impl.WebhookServiceImpl;
import io.meeds.gamification.github.storage.WebHookStorage;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.service.TriggerService;
import java.util.Collections;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/github-test-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml")})
public abstract class BaseGithubTest
extends BaseExoTestCase {
    protected WebhookService webhookService;
    protected GithubTriggerService githubTriggerService;
    protected SettingService settingService;
    protected WebHookStorage webHookStorage;
    @Mock
    protected GithubConsumerService githubConsumerService;
    @Mock
    protected RuleService ruleService;
    @Mock
    protected ConnectorService connectorService;
    @Mock
    protected TriggerService triggerService;
    @Mock
    protected ListenerService listenerService;
    @Mock
    protected EventService eventService;
    protected CodecInitializer codecInitializer;
    protected WebHookDAO webHookDAO;
    protected IdentityManager identityManager;
    protected IdentityRegistry identityRegistry;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.settingService = (SettingService)ExoContainerContext.getService(SettingService.class);
        this.webHookDAO = (WebHookDAO)ExoContainerContext.getService(WebHookDAO.class);
        this.codecInitializer = (CodecInitializer)ExoContainerContext.getService(CodecInitializer.class);
        this.identityRegistry = (IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class);
        this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        this.webHookStorage = (WebHookStorage)ExoContainerContext.getService(WebHookStorage.class);
        this.githubTriggerService = new GithubTriggerServiceImpl(this.listenerService, this.connectorService, this.identityManager, this.eventService, this.triggerService);
        this.webhookService = new WebhookServiceImpl(this.settingService, this.webHookStorage, this.githubConsumerService, this.ruleService);
        this.resetUserSession();
        this.begin();
    }

    @After
    public void tearDown() {
        this.restartTransaction();
        this.webHookDAO.deleteAll();
        this.end();
    }

    protected void resetUserSession() {
        ConversationState.setCurrent(null);
    }

    protected Identity registerAdministratorUser(String user) {
        Identity identity = new Identity(user, Collections.singletonList(new MembershipEntry("/platform/rewarding")));
        this.identityRegistry.register(identity);
        return identity;
    }

    protected Identity registerInternalUser(String username) {
        Identity identity = new Identity(username, Collections.singletonList(new MembershipEntry("/platform/users")));
        this.identityRegistry.register(identity);
        return identity;
    }
}

