/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.rest;

import io.meeds.github.gamification.model.RemoteRepository;
import io.meeds.github.gamification.model.WebHook;
import io.meeds.github.gamification.rest.builder.WebHookBuilder;
import io.meeds.github.gamification.rest.model.RepositoryList;
import io.meeds.github.gamification.rest.model.WebHookRestEntity;
import io.meeds.github.gamification.services.GithubConsumerService;
import io.meeds.github.gamification.services.WebhookService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"hooks"})
@Tag(name="accounts", description="Manage and access twitter watched accounts")
public class HooksManagementRest {
    public static final String GITHUB_HOOK_NOT_FOUND = "The GitHub hook doesn't exit";
    @Autowired
    private WebhookService webhookService;
    @Autowired
    private GithubConsumerService githubConsumerService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieves the list GitHub webHooks", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public PagedModel<EntityModel<WebHookRestEntity>> getWebHooks(HttpServletRequest request, Pageable pageable, PagedResourcesAssembler<WebHookRestEntity> assembler) {
        try {
            Page<WebHookRestEntity> webHookRestEntities = this.getWebHookRestEntities(request.getRemoteUser(), pageable);
            return assembler.toModel(webHookRestEntities);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }

    @GetMapping(path={"{webHookId}"})
    @Secured(value={"users"})
    @Operation(summary="Retrieves a webHook by its technical identifier", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public WebHookRestEntity getWebHookById(HttpServletRequest request, @Parameter(description="WebHook technical identifier", required=true) @PathVariable(value="webHookId") long webHookId) {
        if (webHookId == 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "WebHook Id must be not null");
        }
        try {
            WebHook webHook = this.webhookService.getWebhookId(webHookId, request.getRemoteUser());
            return WebHookBuilder.toRestEntity(this.webhookService, this.githubConsumerService, webHook);
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Create a organization webhook for Remote GitHub connector.", description="Create a organization webhook for Remote GitHub connector.", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void createWebhookHook(HttpServletRequest request, @Parameter(description="GitHub organization name", required=true) @RequestParam(value="organizationName") String organizationName, @Parameter(description="GitHub personal access token", required=true) @RequestParam(value="accessToken") String accessToken) {
        if (StringUtils.isBlank((CharSequence)organizationName)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "'organizationName' parameter is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "'accessToken' parameter is mandatory");
        }
        try {
            this.webhookService.createWebhook(organizationName, accessToken, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectAlreadyExistsException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @PatchMapping(path={"{webHookId}"})
    @Secured(value={"users"})
    @Operation(summary="Update a organization webhook personal access token.", description="Update a organization webhook personal access token.", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void updateWebHookAccessToken(HttpServletRequest request, @Parameter(description="WebHook technical identifier", required=true) @PathVariable(value="webHookId") long webHookId, @Parameter(description="GitHub personal access token", required=true) @RequestParam(value="accessToken") String accessToken) {
        if (webHookId <= 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "'webHookId' must be positive");
        }
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "'accessToken' parameter is mandatory");
        }
        try {
            this.webhookService.updateWebHookAccessToken(webHookId, accessToken, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, GITHUB_HOOK_NOT_FOUND);
        }
    }

    @DeleteMapping(path={"{organizationId}"})
    @Secured(value={"users"})
    @Operation(summary="Deletes gitHub organization webhook", description="Deletes gitHub organization webhook", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void deleteWebhook(HttpServletRequest request, @Parameter(description="GitHub organization id", required=true) @PathVariable(value="organizationId") long organizationId) {
        try {
            this.webhookService.deleteWebhook(organizationId, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @GetMapping(path={"{organizationId}/repos"})
    @Secured(value={"users"})
    @Operation(summary="Retrieves the list GitHub organization repositories", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public RepositoryList getWebHookRepos(HttpServletRequest request, @Parameter(description="GitHub organization id", required=true) @PathVariable(value="organizationId") long organizationId, @Parameter(description="Query page number", required=true) @RequestParam(value="page") int page, @Parameter(description="Query item per page", required=true) @RequestParam(value="perPage") int perPage, @Parameter(description="Keyword to search in repositories title", required=true) @RequestParam(value="keyword") String keyword) {
        try {
            RepositoryList repositoryList = new RepositoryList();
            List<RemoteRepository> remoteRepositories = this.webhookService.retrieveOrganizationRepos(organizationId, request.getRemoteUser(), page, perPage, keyword);
            repositoryList.setRemoteRepositories(remoteRepositories);
            repositoryList.setPage(page);
            repositoryList.setPerPage(perPage);
            return repositoryList;
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, GITHUB_HOOK_NOT_FOUND);
        }
    }

    @PostMapping(path={"repo/status"})
    @Secured(value={"users"})
    @Operation(summary="enables/disables webhook repository.", description="enables/disables webhook repository", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void updateWebHookRepoStatus(HttpServletRequest request, @Parameter(description="GitHub organization remote Id", required=true) @RequestParam(value="organizationId") long organizationId, @Parameter(description="Organization repository remote Id", required=true) @RequestParam(value="repositoryId") long repositoryId, @Parameter(description="Organization repository status enabled/disabled. possible values: true for enabled, else false", required=true) @RequestParam(value="enabled") boolean enabled) {
        try {
            this.webhookService.setWebHookRepositoryEnabled(organizationId, repositoryId, enabled, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }

    private Page<WebHookRestEntity> getWebHookRestEntities(String username, Pageable pageable) throws IllegalAccessException {
        Page<WebHook> webHooks = this.webhookService.getWebhooks(username, pageable);
        return WebHookBuilder.toRestEntities(this.webhookService, this.githubConsumerService, webHooks);
    }
}

