/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.utils;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.Arrays;
import java.util.List;

@Converter
public class StringListConverter
implements AttributeConverter<List<String>, String> {
    private static final String DELIMITER = ",";

    public String convertToDatabaseColumn(List<String> attribute) {
        return attribute != null ? String.join((CharSequence)DELIMITER, attribute) : null;
    }

    public List<String> convertToEntityAttribute(String dbData) {
        return dbData != null ? Arrays.stream(dbData.split(DELIMITER)).toList() : null;
    }
}

