/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.rest.builder;

import io.meeds.github.gamification.model.RemoteOrganization;
import io.meeds.github.gamification.model.TokenStatus;
import io.meeds.github.gamification.model.WebHook;
import io.meeds.github.gamification.rest.model.WebHookRestEntity;
import io.meeds.github.gamification.services.GithubConsumerService;
import io.meeds.github.gamification.services.WebhookService;
import org.springframework.data.domain.Page;

public class WebHookBuilder {
    private WebHookBuilder() {
    }

    public static WebHookRestEntity toRestEntity(WebhookService webhookService, GithubConsumerService githubConsumerService, WebHook webHook) {
        if (webHook == null) {
            return null;
        }
        RemoteOrganization remoteOrganization = null;
        TokenStatus tokenStatus = githubConsumerService.checkGitHubTokenStatus(webHook.getToken());
        if (tokenStatus.isValid() && tokenStatus.getRemaining() > 0L) {
            remoteOrganization = githubConsumerService.retrieveRemoteOrganization(webHook.getOrganizationId(), webHook.getToken());
        }
        return new WebHookRestEntity(webHook.getId(), webHook.getWebhookId(), webHook.getOrganizationId(), webHook.getTriggers(), webHook.getEnabled(), webHook.getWatchedDate(), webHook.getWatchedBy(), webHook.getUpdatedDate(), webHook.getRefreshDate(), webHook.getOrganizationName(), remoteOrganization != null ? remoteOrganization.getTitle() : null, remoteOrganization != null ? remoteOrganization.getDescription() : null, remoteOrganization != null ? remoteOrganization.getAvatarUrl() : null, webhookService.isWebHookWatchLimitEnabled(webHook.getOrganizationId()), tokenStatus);
    }

    public static Page<WebHookRestEntity> toRestEntities(WebhookService webhookService, GithubConsumerService githubConsumerService, Page<WebHook> webHooks) {
        return webHooks.map(webHook -> WebHookBuilder.toRestEntity(webhookService, githubConsumerService, webHook));
    }
}

