/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.rest;

import io.meeds.github.gamification.model.TokenStatus;
import io.meeds.github.gamification.model.WebHook;
import io.meeds.github.gamification.rest.HooksManagementRest;
import io.meeds.github.gamification.services.GithubConsumerService;
import io.meeds.github.gamification.services.WebhookService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={HooksManagementRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
class HooksManagementRestTest {
    private static final String REST_PATH = "/hooks";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    @MockBean
    private WebhookService webhookService;
    @MockBean
    private GithubConsumerService githubConsumerService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    HooksManagementRestTest() {
    }

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getWebHooksAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getWebHooksSimpleUser() throws Exception {
        TokenStatus tokenStatus = new TokenStatus(true, Long.valueOf(12L), Long.valueOf(15454L));
        Mockito.when((Object)this.webhookService.getWebhooks((String)ArgumentMatchers.eq((Object)SIMPLE_USER), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(List.of(this.newWebHook())));
        Mockito.when((Object)this.githubConsumerService.checkGitHubTokenStatus((String)ArgumentMatchers.any())).thenReturn((Object)tokenStatus);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.webhookService)).getWebhooks((String)ArgumentMatchers.eq((Object)SIMPLE_USER), (Pageable)ArgumentMatchers.any());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    void getWebHookByIdAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getWebHookByIdSimpleUser() throws Exception {
        TokenStatus tokenStatus = new TokenStatus(true, Long.valueOf(12L), Long.valueOf(15454L));
        Mockito.when((Object)this.webhookService.getWebhooks((String)ArgumentMatchers.eq((Object)SIMPLE_USER), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(List.of(this.newWebHook())));
        Mockito.when((Object)this.githubConsumerService.checkGitHubTokenStatus((String)ArgumentMatchers.any())).thenReturn((Object)tokenStatus);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/0", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.webhookService)).getWebhookId(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException()}).when((Object)this.webhookService)).getWebhookId(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("Webhook doesn't exist")}).when((Object)this.webhookService)).getWebhookId(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void createWebhookHookAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("organizationName", new String[]{"organizationName"}).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void createWebhookHookSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("accessToken", new String[]{"accessToken"}).param("organizationName", new String[]{""}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("organizationName", new String[]{"organizationName"}).param("accessToken", new String[]{""}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("organizationName", new String[]{"organizationName"}).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.webhookService)).createWebhook("organizationName", "accessToken", SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("organizationName", new String[]{"organizationName"}).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectAlreadyExistsException((Object)this.newWebHook())}).when((Object)this.webhookService)).createWebhook("organizationName", "accessToken", SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("organizationName", new String[]{"organizationName"}).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isConflict());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("github.organizationNotFound")}).when((Object)this.webhookService)).createWebhook("organizationName", "accessToken", SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("organizationName", new String[]{"organizationName"}).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void updateWebHookAccessTokenAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/hooks/1", (Object[])new Object[0]).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateWebHookAccessTokenSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/hooks/-1", (Object[])new Object[0]).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/hooks/1", (Object[])new Object[0]).param("accessToken", new String[]{""}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/hooks/1", (Object[])new Object[0]).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.webhookService)).updateWebHookAccessToken(1L, "accessToken", SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/hooks/1", (Object[])new Object[0]).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("github.organizationNotFound")}).when((Object)this.webhookService)).updateWebHookAccessToken(1L, "accessToken", SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/hooks/1", (Object[])new Object[0]).param("accessToken", new String[]{"accessToken"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void deleteWebhookAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/hooks/1", (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deleteWebhookSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/hooks/1", (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.webhookService)).deleteWebhook(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/hooks/1", (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("github.organizationNotFound")}).when((Object)this.webhookService)).deleteWebhook(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/hooks/1", (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getWebHookReposAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1/repos", (Object[])new Object[0]).param("page", new String[]{"1"}).param("perPage", new String[]{"5"}).param("keyword", new String[]{"keyword"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getWebHookReposSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1/repos", (Object[])new Object[0]).param("page", new String[]{"1"}).param("perPage", new String[]{"5"}).param("keyword", new String[]{"keyword"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.webhookService)).retrieveOrganizationRepos(1L, SIMPLE_USER, 1, 5, "keyword");
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1/repos", (Object[])new Object[0]).param("page", new String[]{"1"}).param("perPage", new String[]{"5"}).param("keyword", new String[]{"keyword"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("github.organizationNotFound")}).when((Object)this.webhookService)).retrieveOrganizationRepos(1L, SIMPLE_USER, 1, 5, "keyword");
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/hooks/1/repos", (Object[])new Object[0]).param("page", new String[]{"1"}).param("perPage", new String[]{"5"}).param("keyword", new String[]{"keyword"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void updateWebHookRepoStatusAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/hooks/repo/status", (Object[])new Object[0]).param("organizationId", new String[]{"1"}).param("repositoryId", new String[]{"125"}).param("enabled", new String[]{"false"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateWebHookRepoStatusSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/hooks/repo/status", (Object[])new Object[0]).param("organizationId", new String[]{"1"}).param("repositoryId", new String[]{"125"}).param("enabled", new String[]{"false"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((WebhookService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.webhookService)).setWebHookRepositoryEnabled(1L, 125L, false, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/hooks/repo/status", (Object[])new Object[0]).param("organizationId", new String[]{"1"}).param("repositoryId", new String[]{"125"}).param("enabled", new String[]{"false"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    private WebHook newWebHook() {
        return new WebHook(1L, 1234L, 12345L, "organizationName", List.of("trigger1", "trigger2"), Boolean.valueOf(true), "watchedDate", "watchedBy", "updatedDate", "refreshDate", "token", "secret");
    }
}

